/*
 * @author lsy
 * @date   2019-10-08
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/commonModel/base/Temp.dart';
import 'package:gmalpha_flutter/commonModel/cache/CacheManager.dart';

abstract class BasePage<T extends StatefulWidget> extends State<T> {
  var startTime;

  String pageName();

  String referrer();

  @override
  void initState() {
    super.initState();
    startTime = DateTime.now().millisecondsSinceEpoch;
  }

  void pageStop(){
    RouterCenterImpl().findBuriedRouter()?.onPageEnd(
        pageName(), "$startTime", "${DateTime.now().millisecondsSinceEpoch}",
        referrer: referrer());
  }

  @override
  void dispose() {
    super.dispose();
    print("lsy SENDDDD  ");
    RouterCenterImpl().findBuriedRouter()?.onPageEnd(
        pageName(), "$startTime", "${DateTime.now().millisecondsSinceEpoch}",
        referrer: referrer());
  }
}
