/*
 * @author lsy
 * @date   2019-09-24
 **/
import 'package:dio/dio.dart';
import 'package:flutter/services.dart';
import 'package:gmalpha_flutter/commonModel/cache/CacheManager.dart';
import 'package:gmalpha_flutter/commonModel/net/Api.dart';
import 'package:gmalpha_flutter/commonModel/net/DioUtil.dart';
import 'package:rxdart/rxdart.dart';

const BURIED_METHOD = "FLUTTER_BURIED";
const NET_TYPE = "GET_NET_TYPE";
const INIT_PARAMS = "INIT_PARAMS";
const platform = const MethodChannel('flutter_bury_channel');

void jumpToH5(String jumpToName, Map params) {
  Map map = {"page_name": jumpToName};
  if (params != null) {
    map.addAll(params);
  }
  platform.invokeMethod("FLUTTER_TO_H5", map);
}

void jumpToNative(String jumpToName, Map params) {
  Map map = {"page_name": jumpToName};
  if (params != null) {
    map.addAll(params);
  }
  platform.invokeMethod("FLUTTER_TO_NATIVE", map);
}

Future getBuriedInfo() async {
  return await platform.invokeMethod(BURIED_METHOD, null);
}

Observable getNetType() {
  return Observable.fromFuture(platform.invokeMethod(NET_TYPE, null));
}

void initParams(VoidCallback callback) {
  platform.invokeMethod(INIT_PARAMS, null).then((value) {
    print("lsy INITPARAMS ！！   $value");
    Api.getInstance().initBuildConfig(value);
    initBuried(callback);
  }).catchError((error) {
    print(error);
  });
}

void initBuried(VoidCallback call) {
  getBuriedInfo().then((value) {
    Map temp = new Map<String, dynamic>.from(value);
    print("lsy INITBURIED ！！   $temp");
    temp.forEach((k, v) {
      CacheManager.getInstance().get(MEMORY_CACHE).save(k, v);
    });
    call();
  }).catchError((error) {
    print(error);
  });
}

String getNowTimeSecond() {
  return "${DateTime.now().millisecondsSinceEpoch}";
//  String year = "${DateTime.now().year}".length == 4
//      ? "${DateTime.now().year}"
//      : "0${DateTime.now().year}";
//  String month = "${DateTime.now().month}".length == 2
//      ? "${DateTime.now().month}"
//      : "0${DateTime.now().month}";
//  String day = "${DateTime.now().day}".length == 2
//      ? "${DateTime.now().day}"
//      : "0${DateTime.now().day}";
//  String hour = "${DateTime.now().hour}".length == 2
//      ? "${DateTime.now().hour}"
//      : "0${DateTime.now().hour}";
//  String minute = "${DateTime.now().minute}".length == 2
//      ? "${DateTime.now().minute}"
//      : "0${DateTime.now().minute}";
//  String second = "${DateTime.now().second}".length == 2
//      ? "${DateTime.now().second}"
//      : "0${DateTime.now().second}";
//
//  return "${year}${month}${day}"
//      "${hour}${minute}${second}";
}
