import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/commonModel/net/ALNetWork.dart';

void main() => runApp(MaterialApp(
      home: NetWorkTestPage(),
    ));

class NetWorkTestPage extends StatefulWidget {
  @override
  _NetWorkTestPageState createState() => _NetWorkTestPageState();
}

class _NetWorkTestPageState extends State<NetWorkTestPage> {

  String _string = 'lalala';

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('NewtWork Test Page'),
      ),
      body: Container(
        padding: EdgeInsets.all(32.0),
        child: Center(
          child: Column(
            children: <Widget>[
              FlatButton(
                child: Text('newtWorkTest'),
                color: Colors.greenAccent,
                onPressed: _netWork,
              ),
              Container(
                color: Colors.greenAccent,
                constraints: BoxConstraints(
                    maxWidth: double.infinity,
                    minWidth: 200.0,
                    maxHeight: 500,
                    minHeight: 200.0),
                child: Text('data:' + _string),
              ),
            ],
          ),
        ),
      ),
    );
  }

  void _netWork() {
    ALNetwork(
      success: (NetworkSuccess success){
        print(success.data);
        setState(() {
          _string = success.data.toString();
        });
      },
      error: (NetworkError error){
        print(error.error);
        setState(() {
          _string = error.error.toString();
        });
      },
      api: '/api/v1/index'
    )
    ..excuteGet();
  }
}