import 'package:flutter/material.dart';
import 'dart:ui' as ui;
import 'package:flutter/services.dart';
// import 'hybrid_stack/hybrid_stack_manager_plugin.dart';


//void main(){
//  return runApp(new InputInviteCodePage());
//}

class InputInviteCodePage extends StatelessWidget{
 
  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        home: InputInviteCodeContent(),
        theme: ThemeData(
            primaryColor: Colors.white,
            highlightColor: Colors.white,
            splashColor: Colors.white70)
    );
  }
}

class InputInviteCodeContent extends StatelessWidget {
  BuildContext context;

  bool isErrorNoticeVisible = false;
  InviteCodeInputText inputText;

  void onLeadingClick() {
    Navigator.pop(context);
  }

  @override
  Widget build(BuildContext context) {
    this.context = context;
    ValueNotifier<bool> errorVisibleNotifierData =
    new ValueNotifier<bool>(isErrorNoticeVisible);

    // TODO: implement build
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          elevation: 0.0,
          leading: IconButton(
              icon: Icon(Icons.arrow_back_ios), onPressed: onLeadingClick),
        ),
        body: Container(
          child: Center(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  Text("输入邀请码",
                      style: TextStyle(fontSize: 25, fontWeight: FontWeight.bold)),
                  SizedBox(width: 10.0, height: 40.0),

                  GestureDetector(
                    onLongPress: () {
//                  print("长按------------");
//                  showDialog(
//                      context: context,
//                      builder: (context) {
//                        return SimpleDialog(children: <Widget>[
//                          ListTile(
//                              title: Text("粘贴",style: TextStyle(),),
//                              onTap: () {
//                                Future<ClipboardData> data =
//                                Clipboard.getData('text/plain');
//                                data.then((value) {
//                                  inviteCodeNotifierData.value = value.text;
//                                });
//                                Navigator.of(context).pop();
//                              })
//                        ]);
//                      });
                    },
                    child: Container(
                      color: Colors.white,
                      child: inputText=InviteCodeInputText(
                        textSize: 30.0,
                        letterSpace: 30.0,
                        inputBorder: CustomRectInputBorder(
                            textSize: 30.0,
                            textLength: 1,
                            borderSide:
                            BorderSide(color: Colors.black, width: 1.5)),
                      ),
                    ),
                  ),
                  SizedBox(width: 10.0, height: 5.0),
                  InviteCodeErrorNoticeText(errorVisibleNotifierData),
                  SizedBox(width: 10.0, height: 70.0),
                  RaisedButton(
                    color: Colors.white,
                    child: Padding(
                        padding: EdgeInsets.fromLTRB(0, 15, 0, 15),
                        child: Text(
                          "确定",
                          style: TextStyle(fontWeight: FontWeight.bold),
                        )),
                    elevation: 0.0,
                    padding: EdgeInsets.fromLTRB(70, 0, 70, 0),
                    onPressed: () {
                      errorVisibleNotifierData.value = isErrorNoticeVisible;
                      isErrorNoticeVisible = !isErrorNoticeVisible;

                      print("邀请码=================="+inputText.state.textSlotChar[0]+
                          inputText.state.textSlotChar[1]+
                          inputText.state.textSlotChar[2]+
                          inputText.state.textSlotChar[3]+
                          inputText.state.textSlotChar[4]);

                    },
                    shape: Border(
                        top: BorderSide(color: Colors.black, width: 2.0),
                        right: BorderSide(color: Colors.black, width: 2.0),
                        bottom: BorderSide(color: Colors.black, width: 2.0),
                        left: BorderSide(color: Colors.black, width: 2.0)),
                  ),
                  SizedBox(width: 10.0, height: 90.0),
                ],
              )),
        ));
  }
}

class InviteCodeErrorNoticeText extends StatefulWidget {
  InviteCodeErrorNoticeOpenState state;
  ValueNotifier<bool> data;

  InviteCodeErrorNoticeText(this.data);

  @override
  State<StatefulWidget> createState() {
    // TODO: implement createState
    return state = InviteCodeErrorNoticeOpenState();
  }
}

class InviteCodeErrorNoticeOpenState extends State<InviteCodeErrorNoticeText> {
  bool errorNoticeVisible = true;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    widget.data.addListener(() {
      changeVisibleParams(widget.data.value);
    });
  }

  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    return IgnorePointer(
        child: Opacity(
            opacity: errorNoticeVisible == true ? 1.0 : 0.0,
            child: Text("未找到邀请者 请确认邀请码是否正确",
              textAlign: TextAlign.center,
              style: TextStyle(color: Colors.black,fontSize: 13),
            )));
  }

  void changeVisibleParams(bool visible) {
    setState(() {
      this.errorNoticeVisible = visible;
    });
  }
}

class InviteCodeInputText extends StatefulWidget {
  final double letterSpace;
  final double textSize;
  final int codeLength;
  final InputBorder inputBorder;
  InviteCodeInputState state;

  InviteCodeInputText(
      {Key key,
        this.letterSpace = 20.0,
        this.textSize = 20.0,
        this.codeLength = 5,
        this.inputBorder})
      : super(key: key);

  @override
  State<StatefulWidget> createState() {
    // TODO: implement createState
    return state=InviteCodeInputState();
  }
}

class InviteCodeInputState extends State<InviteCodeInputText> {
  var textFieldArr = List<TextField>(5);
  var textSlotChar = List<String>(5);

  @override
  void initState() {
    // TODO: implement initState
    super.initState();

    textFieldArr[0] = TextField(
      maxLength: 1,
      keyboardType: TextInputType.number,
      cursorColor: Colors.transparent,
      style: TextStyle(
        fontSize: widget.textSize,
        fontWeight: FontWeight.bold,
        color: Colors.black,
      ),
      enableInteractiveSelection: false,
      focusNode: FocusNode(),
      onChanged: (String res) {
        if (res.length > 0) {
          FocusNode node = textFieldArr[1].focusNode;
          FocusScope.of(context).requestFocus(node);
        }

        textSlotChar[0]=res;
      },
      textAlign: TextAlign.center,
      decoration: InputDecoration(
          counterText: "",
          enabledBorder: widget.inputBorder,
          focusedBorder: widget.inputBorder),
      onSubmitted: (text) {},
    );

    textFieldArr[1] = TextField(
      maxLength: 1,
      keyboardType: TextInputType.number,
      cursorColor: Colors.transparent,
      style: TextStyle(
        fontWeight: FontWeight.bold,
        fontSize: widget.textSize,
        color: Colors.black,
      ),
      enableInteractiveSelection: false,
      focusNode: FocusNode(),
      onChanged: (String res) {
        if (res.length > 0) {
          FocusNode node = textFieldArr[2].focusNode;
          FocusScope.of(context).requestFocus(node);
        } else if (res.isEmpty) {
          FocusNode node = textFieldArr[0].focusNode;
          FocusScope.of(context).requestFocus(node);
        }

        textSlotChar[1]=res;
      },
      textAlign: TextAlign.center,
      decoration: InputDecoration(
          counterText: "",
          enabledBorder: widget.inputBorder,
          focusedBorder: widget.inputBorder),
      onSubmitted: (text) {},
    );

    textFieldArr[2] = TextField(
      maxLength: 1,
      keyboardType: TextInputType.number,
      cursorColor: Colors.transparent,
      style: TextStyle(
        fontWeight: FontWeight.bold,
        fontSize: widget.textSize,
        color: Colors.black,
      ),
      enableInteractiveSelection: false,
      focusNode: FocusNode(),
      onChanged: (String res) {
        if (res.length > 0) {
          FocusNode node = textFieldArr[3].focusNode;
          FocusScope.of(context).requestFocus(node);
        } else if (res.isEmpty) {
          FocusNode node = textFieldArr[1].focusNode;
          FocusScope.of(context).requestFocus(node);
        }

        textSlotChar[2]=res;
      },
      textAlign: TextAlign.center,
      decoration: InputDecoration(
          counterText: "",
          enabledBorder: widget.inputBorder,
          focusedBorder: widget.inputBorder),
      onSubmitted: (text) {},
    );

    textFieldArr[3] = TextField(
      maxLength: 1,
      keyboardType: TextInputType.number,
      cursorColor: Colors.transparent,
      style: TextStyle(
        fontWeight: FontWeight.bold,
        fontSize: widget.textSize,
        color: Colors.black,
      ),
      enableInteractiveSelection: false,
      focusNode: FocusNode(),
      onChanged: (String res) {
        if (res.length > 0) {
          FocusNode node = textFieldArr[4].focusNode;
          FocusScope.of(context).requestFocus(node);
        } else if (res.isEmpty) {
          FocusNode node = textFieldArr[2].focusNode;
          FocusScope.of(context).requestFocus(node);
        }

        textSlotChar[3]=res;
      },
      textAlign: TextAlign.center,
      decoration: InputDecoration(
          counterText: "",
          enabledBorder: widget.inputBorder,
          focusedBorder: widget.inputBorder),
      onSubmitted: (text) {},
    );

    textFieldArr[4] = TextField(
      maxLength: 1,
      keyboardType: TextInputType.number,
      cursorColor: Colors.transparent,
      style: TextStyle(
        fontWeight: FontWeight.bold,
        fontSize: widget.textSize,
        color: Colors.black,
      ),
      enableInteractiveSelection: false,
      focusNode: FocusNode(),
      onChanged: (String res) {
        if (res.isEmpty) {
          FocusNode node = textFieldArr[3].focusNode;
          FocusScope.of(context).requestFocus(node);
        }

        textSlotChar[4]=res;
      },
      textAlign: TextAlign.center,
      decoration: InputDecoration(
          counterText: "",
          enabledBorder: widget.inputBorder,
          focusedBorder: widget.inputBorder),
      onSubmitted: (text) {},
    );
  }

  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    return Row(
      mainAxisSize: MainAxisSize.min,
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        ConstrainedBox(
            constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
            child: textFieldArr[0]),
        SizedBox(height: 80, width: 10),
        ConstrainedBox(
            constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
            child: textFieldArr[1]),
        SizedBox(height: 80, width: 10),
        ConstrainedBox(
            constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
            child: textFieldArr[2]),
        SizedBox(height: 80, width: 10),
        ConstrainedBox(
            constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
            child: textFieldArr[3]),
        SizedBox(height: 80, width: 10),
        ConstrainedBox(
            constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
            child: textFieldArr[4]),
      ],
    );
  }
}

class CustomRectInputBorder extends InputBorder {
  CustomRectInputBorder({
    double textSize = 0.0,
    int textLength,
    BorderSide borderSide = const BorderSide(),
  }) : super(
      textSize: textSize, textLength: textLength, borderSide: borderSide);

  double get offsetX => textTrueWidth * 0.3;

  double get offsetY => textTrueWidth * 0.3;

  @override
  void paint(
      Canvas canvas,
      Rect rect, {
        double gapStart,
        double gapExtent = 0.0,
        double gapPercentage = 0.0,
        TextDirection textDirection,
      }) {
    Rect fixRect = Rect.fromLTWH(rect.left, rect.top, rect.right, rect.bottom);
    canvas.drawRect(fixRect, borderSide.toPaint());
  }
}

abstract class InputBorder extends UnderlineInputBorder {
  double textSize;
  int textLength;

  double textTrueWidth;
  final double startOffset;

  InputBorder({
    this.textSize = 0.0,
    this.textLength,
    BorderSide borderSide = const BorderSide(),
  })  : startOffset = 0,
        super(borderSide: borderSide) {
    calculateTextWidth();
  }

  void calculateTextWidth() {
    // 测量单个数字实际长度
    var paragraph = ui.ParagraphBuilder(ui.ParagraphStyle(fontSize: textSize))
      ..addText("0");
    var p = paragraph.build()
      ..layout(ui.ParagraphConstraints(width: double.infinity));
    textTrueWidth = p.minIntrinsicWidth;
  }
}
// import 'package:flutter/material.dart';
// import 'dart:ui' as ui;
// import 'package:flutter/services.dart';
// import 'hybrid_stack/hybrid_stack_manager_plugin.dart';

// class InputInviteCode extends StatelessWidget {

//   RouterOption routeOption;
//   InputInviteCode(RouterOption option, {Key key}) : super(key: key) {
//     routeOption = option;
//   }

//   @override
//   Widget build(BuildContext context) {
//     // TODO: implement build
//     return MaterialApp(
//         debugShowCheckedModeBanner: false,
//         home: InputInviteCodeContent(),
//         theme: ThemeData(
//             primaryColor: Colors.white,
//             highlightColor: Colors.white,
//             splashColor: Colors.white70)
//     );
//   }
// }

// class InputInviteCodeContent extends StatelessWidget {
//   BuildContext context;

//   bool isErrorNoticeVisible = false;
//   InviteCodeInputText inputText;

//   void onLeadingClick() {
//     HybridStackManagerPlugin.hybridStackManagerPlugin.popCurPage();
//   }

//   @override
//   Widget build(BuildContext context) {
//     this.context = context;
//     ValueNotifier<bool> errorVisibleNotifierData =
//     new ValueNotifier<bool>(isErrorNoticeVisible);

//     // TODO: implement build
//     return Scaffold(
//         backgroundColor: Colors.white,
//         appBar: AppBar(
//           elevation: 0.0,
//           leading: IconButton(
//               icon: Icon(Icons.arrow_back_ios), onPressed: onLeadingClick),
//         ),
//         body: Container(
//           child: Center(
//               child: Column(
//                 mainAxisAlignment: MainAxisAlignment.center,
//                 crossAxisAlignment: CrossAxisAlignment.center,
//                 children: <Widget>[
//                   Text("输入邀请码",
//                       style: TextStyle(fontSize: 25, fontWeight: FontWeight.bold)),
//                   SizedBox(width: 10.0, height: 40.0),

//                   GestureDetector(
//                     onLongPress: () {
// //                  print("长按------------");
// //                  showDialog(
// //                      context: context,
// //                      builder: (context) {
// //                        return SimpleDialog(children: <Widget>[
// //                          ListTile(
// //                              title: Text("粘贴",style: TextStyle(),),
// //                              onTap: () {
// //                                Future<ClipboardData> data =
// //                                Clipboard.getData('text/plain');
// //                                data.then((value) {
// //                                  inviteCodeNotifierData.value = value.text;
// //                                });
// //                                Navigator.of(context).pop();
// //                              })
// //                        ]);
// //                      });
//                     },
//                     child: Container(
//                       color: Colors.white,
//                       child: inputText=InviteCodeInputText(
//                         textSize: 30.0,
//                         letterSpace: 30.0,
//                         inputBorder: CustomRectInputBorder(
//                             textSize: 30.0,
//                             textLength: 1,
//                             borderSide:
//                             BorderSide(color: Colors.black, width: 1.5)),
//                       ),
//                     ),
//                   ),
//                   SizedBox(width: 10.0, height: 5.0),
//                   InviteCodeErrorNoticeText(errorVisibleNotifierData),
//                   SizedBox(width: 10.0, height: 70.0),
//                   RaisedButton(
//                     color: Colors.white,
//                     child: Padding(
//                         padding: EdgeInsets.fromLTRB(0, 15, 0, 15),
//                         child: Text(
//                           "确定",
//                           style: TextStyle(fontWeight: FontWeight.bold),
//                         )),
//                     elevation: 0.0,
//                     padding: EdgeInsets.fromLTRB(70, 0, 70, 0),
//                     onPressed: () {
//                       errorVisibleNotifierData.value = isErrorNoticeVisible;
//                       isErrorNoticeVisible = !isErrorNoticeVisible;

//                       print("邀请码=================="+inputText.state.textSlotChar[0]+
//                           inputText.state.textSlotChar[1]+
//                           inputText.state.textSlotChar[2]+
//                           inputText.state.textSlotChar[3]+
//                           inputText.state.textSlotChar[4]);

//                     },
//                     shape: Border(
//                         top: BorderSide(color: Colors.black, width: 2.0),
//                         right: BorderSide(color: Colors.black, width: 2.0),
//                         bottom: BorderSide(color: Colors.black, width: 2.0),
//                         left: BorderSide(color: Colors.black, width: 2.0)),
//                   ),
//                   SizedBox(width: 10.0, height: 90.0),
//                 ],
//               )),
//         ));
//   }
// }

// class InviteCodeErrorNoticeText extends StatefulWidget {
//   InviteCodeErrorNoticeOpenState state;
//   ValueNotifier<bool> data;

//   InviteCodeErrorNoticeText(this.data);

//   @override
//   State<StatefulWidget> createState() {
//     // TODO: implement createState
//     return state = InviteCodeErrorNoticeOpenState();
//   }
// }

// class InviteCodeErrorNoticeOpenState extends State<InviteCodeErrorNoticeText> {
//   bool errorNoticeVisible = true;

//   @override
//   void initState() {
//     // TODO: implement initState
//     super.initState();
//     widget.data.addListener(() {
//       changeVisibleParams(widget.data.value);
//     });
//   }

//   @override
//   Widget build(BuildContext context) {
//     // TODO: implement build
//     return IgnorePointer(
//         child: Opacity(
//             opacity: errorNoticeVisible == true ? 1.0 : 0.0,
//             child: Text("未找到邀请者 请确认邀请码是否正确",
//               textAlign: TextAlign.center,
//               style: TextStyle(color: Colors.black,fontSize: 13),
//             )));
//   }

//   void changeVisibleParams(bool visible) {
//     setState(() {
//       this.errorNoticeVisible = visible;
//     });
//   }
// }

// class InviteCodeInputText extends StatefulWidget {
//   final double letterSpace;
//   final double textSize;
//   final int codeLength;
//   final InputBorder inputBorder;
//   InviteCodeInputState state;

//   InviteCodeInputText(
//       {Key key,
//         this.letterSpace = 20.0,
//         this.textSize = 20.0,
//         this.codeLength = 5,
//         this.inputBorder})
//       : super(key: key);

//   @override
//   State<StatefulWidget> createState() {
//     // TODO: implement createState
//     return state=InviteCodeInputState();
//   }
// }

// class InviteCodeInputState extends State<InviteCodeInputText> {
//   var textFieldArr = List<TextField>(5);
//   var textSlotChar = List<String>(5);

//   @override
//   void initState() {
//     // TODO: implement initState
//     super.initState();

//     textFieldArr[0] = TextField(
//       maxLength: 1,
//       keyboardType: TextInputType.number,
//       cursorColor: Colors.transparent,
//       style: TextStyle(
//         fontSize: widget.textSize,
//         fontWeight: FontWeight.bold,
//         color: Colors.black,
//       ),
//       enableInteractiveSelection: false,
//       focusNode: FocusNode(),
//       onChanged: (String res) {
//         if (res.length > 0) {
//           FocusNode node = textFieldArr[1].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         }

//         textSlotChar[0]=res;
//       },
//       textAlign: TextAlign.center,
//       decoration: InputDecoration(
//           counterText: "",
//           enabledBorder: widget.inputBorder,
//           focusedBorder: widget.inputBorder),
//       onSubmitted: (text) {},
//     );

//     textFieldArr[1] = TextField(
//       maxLength: 1,
//       keyboardType: TextInputType.number,
//       cursorColor: Colors.transparent,
//       style: TextStyle(
//         fontWeight: FontWeight.bold,
//         fontSize: widget.textSize,
//         color: Colors.black,
//       ),
//       enableInteractiveSelection: false,
//       focusNode: FocusNode(),
//       onChanged: (String res) {
//         if (res.length > 0) {
//           FocusNode node = textFieldArr[2].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         } else if (res.isEmpty) {
//           FocusNode node = textFieldArr[0].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         }

//         textSlotChar[1]=res;
//       },
//       textAlign: TextAlign.center,
//       decoration: InputDecoration(
//           counterText: "",
//           enabledBorder: widget.inputBorder,
//           focusedBorder: widget.inputBorder),
//       onSubmitted: (text) {},
//     );

//     textFieldArr[2] = TextField(
//       maxLength: 1,
//       keyboardType: TextInputType.number,
//       cursorColor: Colors.transparent,
//       style: TextStyle(
//         fontWeight: FontWeight.bold,
//         fontSize: widget.textSize,
//         color: Colors.black,
//       ),
//       enableInteractiveSelection: false,
//       focusNode: FocusNode(),
//       onChanged: (String res) {
//         if (res.length > 0) {
//           FocusNode node = textFieldArr[3].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         } else if (res.isEmpty) {
//           FocusNode node = textFieldArr[1].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         }

//         textSlotChar[2]=res;
//       },
//       textAlign: TextAlign.center,
//       decoration: InputDecoration(
//           counterText: "",
//           enabledBorder: widget.inputBorder,
//           focusedBorder: widget.inputBorder),
//       onSubmitted: (text) {},
//     );

//     textFieldArr[3] = TextField(
//       maxLength: 1,
//       keyboardType: TextInputType.number,
//       cursorColor: Colors.transparent,
//       style: TextStyle(
//         fontWeight: FontWeight.bold,
//         fontSize: widget.textSize,
//         color: Colors.black,
//       ),
//       enableInteractiveSelection: false,
//       focusNode: FocusNode(),
//       onChanged: (String res) {
//         if (res.length > 0) {
//           FocusNode node = textFieldArr[4].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         } else if (res.isEmpty) {
//           FocusNode node = textFieldArr[2].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         }

//         textSlotChar[3]=res;
//       },
//       textAlign: TextAlign.center,
//       decoration: InputDecoration(
//           counterText: "",
//           enabledBorder: widget.inputBorder,
//           focusedBorder: widget.inputBorder),
//       onSubmitted: (text) {},
//     );

//     textFieldArr[4] = TextField(
//       maxLength: 1,
//       keyboardType: TextInputType.number,
//       cursorColor: Colors.transparent,
//       style: TextStyle(
//         fontWeight: FontWeight.bold,
//         fontSize: widget.textSize,
//         color: Colors.black,
//       ),
//       enableInteractiveSelection: false,
//       focusNode: FocusNode(),
//       onChanged: (String res) {
//         if (res.isEmpty) {
//           FocusNode node = textFieldArr[3].focusNode;
//           FocusScope.of(context).requestFocus(node);
//         }

//         textSlotChar[4]=res;
//       },
//       textAlign: TextAlign.center,
//       decoration: InputDecoration(
//           counterText: "",
//           enabledBorder: widget.inputBorder,
//           focusedBorder: widget.inputBorder),
//       onSubmitted: (text) {},
//     );
//   }

//   @override
//   Widget build(BuildContext context) {
//     // TODO: implement build
//     return Row(
//       mainAxisSize: MainAxisSize.min,
//       mainAxisAlignment: MainAxisAlignment.center,
//       children: <Widget>[
//         ConstrainedBox(
//             constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
//             child: textFieldArr[0]),
//         SizedBox(height: 80, width: 10),
//         ConstrainedBox(
//             constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
//             child: textFieldArr[1]),
//         SizedBox(height: 80, width: 10),
//         ConstrainedBox(
//             constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
//             child: textFieldArr[2]),
//         SizedBox(height: 80, width: 10),
//         ConstrainedBox(
//             constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
//             child: textFieldArr[3]),
//         SizedBox(height: 80, width: 10),
//         ConstrainedBox(
//             constraints: BoxConstraints(maxWidth: 45, maxHeight: 60),
//             child: textFieldArr[4]),
//       ],
//     );
//   }
// }

// class CustomRectInputBorder extends InputBorder {
//   CustomRectInputBorder({
//     double textSize = 0.0,
//     int textLength,
//     BorderSide borderSide = const BorderSide(),
//   }) : super(
//       textSize: textSize, textLength: textLength, borderSide: borderSide);

//   double get offsetX => textTrueWidth * 0.3;

//   double get offsetY => textTrueWidth * 0.3;

//   @override
//   void paint(
//       Canvas canvas,
//       Rect rect, {
//         double gapStart,
//         double gapExtent = 0.0,
//         double gapPercentage = 0.0,
//         TextDirection textDirection,
//       }) {
//     Rect fixRect = Rect.fromLTWH(rect.left, rect.top, rect.right, rect.bottom);
//     canvas.drawRect(fixRect, borderSide.toPaint());
//   }
// }

// abstract class InputBorder extends UnderlineInputBorder {
//   double textSize;
//   int textLength;

//   double textTrueWidth;
//   final double startOffset;

//   InputBorder({
//     this.textSize = 0.0,
//     this.textLength,
//     BorderSide borderSide = const BorderSide(),
//   })  : startOffset = 0,
//         super(borderSide: borderSide) {
//     calculateTextWidth();
//   }

//   void calculateTextWidth() {
//     // 测量单个数字实际长度
//     var paragraph = ui.ParagraphBuilder(ui.ParagraphStyle(fontSize: textSize))
//       ..addText("0");
//     var p = paragraph.build()
//       ..layout(ui.ParagraphConstraints(width: double.infinity));
//     textTrueWidth = p.minIntrinsicWidth;
//   }
// }
