import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/Error_Page.dart';
import 'package:gmalpha_flutter/TestPage.dart';
import 'package:gmalpha_flutter/commonModel/app_module.dart';
import 'package:gmalpha_flutter/commonModel/base/Temp.dart';
import 'package:gmalpha_flutter/commonModel/cache/CacheManager.dart';
import 'package:gmalpha_flutter/commonModel/net/Api.dart';
import 'package:gmalpha_flutter/messageModel/home/message_home.dart';


void main() {
  initParams(() => runApp(MyApp()));
}

class MyApp extends StatefulWidget {
  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  void initState() {
    super.initState();
    FlutterBoost.singleton.registerPageBuilders({
//      'comment_suggest': (pageName, params, _) => CommentSuggest(params),
      'message_home': (pageName, params, _) => MessageHomePage(params),
      'album': (pageName, params, _) {
        if (params == null) {
          return ErrorPage("出错：需要传递的参数为空");
        }
        var provider = params["provider"] as String;
        return RouterCenterImpl().findAlbumRouter().getAlbumPage(
            provider,
            params["needCamera"] == null
                ? true
                : params["needCamera"] == "0" ? true : false,
            params["maxCount"] == null ? 1 : int.parse(params["maxCount"]),
            params["selectedPath"] == null
                ? null
                : params["selectedPath"] as List<String>);
      },
      "prestige": (pageName, params, _) {
        print("PARAMS!! ${params}");
        if (!Api.getInstance().setDioCookie(params) ||
            params["fromPage"] == null) {
          return ErrorPage("出错：需要传递的参数为空");
        }
        int userId = int.parse(params["userId"]);
        return RouterCenterImpl().findPrestigeRouter()?.getReputationsPage(
            userId, params["userName"], params["fromPage"]);
      },
      "activity_report": (pageName, params, _) {
        print("PARAMS!! ${params}");
        if (!Api.getInstance().setDioCookie(params) ||
            params["fromPage"] == null) {
          return ErrorPage("出错：需要传递的参数为空");
        }
        return RouterCenterImpl()
            .findActivityReportRouter()
            ?.getActivityReportPage(
                params["survey_record_id"] == null
                    ? null
                    : int.parse(params["survey_record_id"]),
                params["template_id"] == null
                    ? null
                    : int.parse(params["template_id"]),
                params["fromPage"]);
      }
    });
    FlutterBoost.handleOnStartPage();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Boost example',
      debugShowCheckedModeBanner: false,
      routes: {
        '/': (context) {
          return TestPage();
        },
      },
      builder: FlutterBoost.init(postPush: _onRoutePushed),
      theme: new ThemeData(
        primaryColor: Colors.white,
        backgroundColor: Color(0xFFEFEFEF),
        accentColor: Color(0xFF888888),
        textTheme: TextTheme(
          //设置Material的默认字体样式
          body1: TextStyle(color: Color(0xFF888888), fontSize: 16.0),
        ),
        iconTheme: IconThemeData(
          color: Color(0xFFEFEFEF),
          size: 35.0,
        ),
      ),
    );
  }

  void _onRoutePushed(
      String pageName, String uniqueId, Map params, Route route, Future _) {
    print("PUSHED $pageName");
  }
}


