import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/commonModel/ui/ALColors.dart';
import 'package:gmalpha_flutter/messageModel/model/message/message.dart';

class MessageNotificationItem extends StatelessWidget {
  final NotificationItem notification;
  VoidCallback onPressed;

  MessageNotificationItem({Key key, this.notification, this.onPressed}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    
   var icon = new Container(
     child:  new Padding(
      padding: EdgeInsets.only(left: 20, top: 17, bottom: 17),
      child: ImageIcon(
        AssetImage(notification.icon),
        color: ALColors.Color323232,
        size: 30,
      ),
     )
   );

    var titleRow = new Container(
              width: 250,
              child: new Row(
                children: <Widget>[
                  Text(notification.title, style: TextStyle(color: Color(0xff323232), fontWeight: FontWeight.bold, fontSize: 13)),
                  Padding(padding: EdgeInsets.only(left: 8)),
                  new Expanded(
                    child: Text(notification.content, maxLines: 1, overflow: TextOverflow.ellipsis, style: new TextStyle(color: Color(0xff8e8e8e), fontSize: 13,), textAlign: TextAlign.justify,),
                  )
                ],
              ),
              // child: Text(notification.content, maxLines: 1, overflow: TextOverflow.ellipsis, style: new TextStyle(color: Color(0xff8e8e8e), fontSize: 13,), textAlign: TextAlign.justify,),
     );

     Widget _notiContent() {
       var content;
        if (notification.count > 0 ){
          content =  new ClipRRect(
              borderRadius: BorderRadius.circular(11),
              child: new Container(
                height: 22,
                color: ALColors.Color323232,
                child: Padding(
                  padding: EdgeInsets.only(top: 4.5, left: 9, right: 9),
                  child: Text(notification.count.toString(), style: TextStyle(color: Color(0xffffffff),fontSize: 11),),
                ),
              ),
            );
          } else {
            content = new Container(height:0.0,width:0.0);
          }
          return content;
     }

    var rigtIcon = new Expanded(
      child: new Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          _notiContent(),
          new Padding(
            padding: EdgeInsets.only(right: 5),
            child: new ImageIcon(
            AssetImage('images/arrow_right.png'),
            color: ALColors.Color323232,
            // size: 30,
            ),
          )
        ],
      ),
    );    

    return new GestureDetector(
      onTap: onPressed,
      // onTap: timeStr(),
      child: new Row(
          children: <Widget>[
            icon,
            Padding(padding: new EdgeInsets.only(left: 13.0)),
            titleRow,
            rigtIcon,
            // arrow,
          ],
      ),
    );
  }
}
