//
//  opinion
//
//  gmalpha_flutter
//  Created by Mikasa on 2019/2/19.
//  Copyright © 2019 Gengmei. All rights reserved.
//  意见与建议页面

import 'package:dio/dio.dart';
import 'package:flutter_boost/flutter_boost.dart';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';
import 'package:gmalpha_flutter/commonModel/base/BasePage.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseState.dart';
import 'package:gmalpha_flutter/userModel/page/comment/CommentModel.dart';
import '../../../commonModel/ui/ALColors.dart';
import '../../../commonModel/ui/ALDevice.dart';

class CommentSuggestPage extends StatefulWidget {
  var _model;

  CommentSuggestPage(String refer) {
    _model = CommentModel(refer);
  }

  @override
  State<StatefulWidget> createState() => _CommentSuggestPageState(_model);
}

class _CommentSuggestPageState extends BasePage<CommentSuggestPage> {
  TextEditingController opinionCtrl = TextEditingController();
  TextEditingController telCtrl = TextEditingController();

  CommentModel _model;

  _CommentSuggestPageState(this._model);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: baseAppBar(
            title: '意见与建议',
            backClick: () {
              Navigator.pop(context);
            }),
        body: new SingleChildScrollView(
          child: Center(
            child: Column(
              // mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                Container(
                  alignment: Alignment.topCenter,
                  margin:
                      EdgeInsets.only(left: 30, top: 50, right: 30, bottom: 0),
                  height: 215,
                  decoration: BoxDecoration(
                    border: Border.all(color: ALColors.ColorC4C4C4, width: 1),
                  ),
                  child: TextField(
                    maxLines: 10,
                    controller: opinionCtrl,
                    decoration: InputDecoration(
                      border: InputBorder.none,
                      contentPadding: EdgeInsets.all(10),
                      hintText: '意见与建议',
                      hintStyle: TextStyle(
                        color: ALColors.ColorC4C4C4,
                        fontSize: 14,
                      ),
                      labelStyle:
                          TextStyle(color: ALColors.Color323232, fontSize: 19),
                    ),
                  ),
                ),
                Container(
                  height: 30,
                  margin: EdgeInsets.only(left: 30, right: 30, top: 40),
                  // padding: EdgeInsets.only(bottom: 10),
                  decoration: BoxDecoration(
                      border: Border(
                    bottom: BorderSide(color: ALColors.ColorC4C4C4),
                  )),
                  alignment: Alignment.centerLeft,
                  child: TextField(
                    controller: telCtrl,
                    decoration: InputDecoration(
                      border: InputBorder.none,
                      contentPadding: EdgeInsets.all(10),
                      hintText: '联系方式',
                      hintStyle: TextStyle(
                        color: ALColors.ColorC4C4C4,
                        fontSize: 14,
                      ),
                      labelStyle:
                          TextStyle(color: ALColors.Color323232, fontSize: 19),
                    ),
                  ),
                ),
                Container(
                  alignment: Alignment.bottomCenter,
                  decoration: BoxDecoration(
                      border:
                          Border.all(color: ALColors.Color323232, width: 1.5)),
                  margin: EdgeInsets.only(
                      left: 30, right: 30, bottom: 30, top: 180),
                  // padding: EdgeInsets.all(0),
                  constraints:
                      BoxConstraints(minWidth: ALDevice.width, minHeight: 45),
                  child: FlatButton(
                    onPressed: () {
                      _model.confirmClick(
                          context, opinionCtrl.text ?? "", telCtrl.text ?? "");
                    },
                    child: Text(
                      '提交',
                      style:
                          TextStyle(fontSize: 14, color: ALColors.Color323232),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ));
  }

  @override
  void dispose() {
    super.dispose();
    opinionCtrl.dispose();
    telCtrl.dispose();
  }

  @override
  String pageName() {
    return "comment_arguement";
  }

  @override
  String referrer() {
    return _model.refer;
  }
}
