/*
 * @author lsy
 * @date   2019-09-04
 **/

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gmalpha_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseUtil.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';
import 'package:gmalpha_flutter/userModel/service/UserRepository.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.user.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserResultBean.dart';

import '../../../commonModel/live/LiveData.dart';

class UserSettingModel extends BaseModel {
  LiveData<String> nameLive = new LiveData();
  LiveData<String> cityLive = new LiveData();
  LiveData<String> headImgLive = new LiveData();
  LiveData<bool> saveLive = new LiveData();

  final String userid;
  final String refere;

  UserSettingModel(this.userid, this.refere);

  init(BuildContext context) {
    UserEntityImpl().getuserId().listen((value) {
      print("VALUEE  $value");
      if (value == null || value != userid) {
        UserRepository.getInstance().getUserInfo(userid).listen((data) {
          print(data);
          nameLive.notifyView(data?.data?.nickName);
          cityLive.notifyView(data?.data?.countryInfo?.name);
          headImgLive.notifyView(data?.data?.profilePic);
        }).onError((error) {
          print(error);
          Toast.show(context, error);
        });
      } else {
        UserEntityImpl().getnickName().listen((data) {
          print("NICK $data");
          nameLive.notifyView(data);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
        UserEntityImpl().getcountryInfoName().listen((data) {
          print("con $data");
          cityLive.notifyView(data);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
        UserEntityImpl().getprofilePic().listen((value) {
          print("head $value");
          headImgLive.notifyView(value);
        }).onError((error) {
          print(error);
          Toast.debugShow(context, error);
        });
      }
    });
  }

  @override
  void dispose() {
    nameLive.dispost();
    headImgLive.dispost();
    cityLive.dispost();
    saveLive.dispost();
  }
}
