/*
 * @author lsy
 * @date   2019-09-04
 **/

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseBuried.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';
import 'package:gmalpha_flutter/commonModel/base/BasePage.dart';
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/userModel/page/userSetting/UserSettingModel.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/userModel/util/JumpUtil.dart';

class UserSettingPage extends StatefulWidget {
  UserSettingModel _model;

  UserSettingPage(String userid, String refer) {
    _model = new UserSettingModel(userid, refer);
  }

  @override
  State<StatefulWidget> createState() => UserState(_model);
}

class UserState extends BasePage<UserSettingPage> {
  final UserSettingModel _model;

  UserState(this._model);

  @override
  void initState() {
    super.initState();
    _model.init(context);
  }

  @override
  void dispose() {
    super.dispose();
    _model.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ScreenUtil.instance = ScreenUtil(width: 375, height: 667)..init(context);
    return Scaffold(
      appBar: baseAppBar(
          backClick: () {
            clickEvent(pageName(), "return");
            Navigator.pop(context);
          },
          action: <Widget>[
            StreamBuilder<bool>(
              stream: _model.saveLive.stream,
              initialData: _model.saveLive.data,
              builder: (context, data) {
                if (data.data == null || !data.data) {
                  return Padding(
                    padding: EdgeInsets.only(
                        right: ScreenUtil.instance.setWidth(30)),
                    child: Center(
                      child: baseText("保存", 14, 0xffC4C4C4),
                    ),
                  );
                } else {
                  return GestureDetector(
                      onTap: () {},
                      child: Padding(
                        padding: EdgeInsets.only(
                            right: ScreenUtil.instance.setWidth(30)),
                        child: Center(
                          child: baseText("保存", 14, 0xff323232),
                        ),
                      ));
                }
              },
            )
          ]),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.fromLTRB(ScreenUtil.instance.setWidth(29),
                ScreenUtil.instance.setWidth(25), 0, 0),
            child: baseText("设置", 30, 0xff323232),
          ),
          Container(
              width: ScreenUtil.instance.setWidth(127),
              height: ScreenUtil.instance.setHeight(127),
              margin: EdgeInsets.fromLTRB(
                  ScreenUtil.instance.setWidth(26),
                  ScreenUtil.instance.setWidth(23),
                  0,
                  ScreenUtil.instance.setWidth(23)),
              child: GestureDetector(
                onTap: () {},
                child: Stack(
                  alignment: Alignment.bottomRight,
                  children: <Widget>[
                    StreamBuilder<String>(
                      stream: _model.headImgLive.stream,
                      initialData: _model.headImgLive.data,
                      builder: (con, data) {
                        if (data.data == null || data.data.isEmpty) {
                          return SvgPicture.asset("images/replace_head.svg");
                        } else {
                          return ClipOval(
                              child: CachedNetworkImage(
                            imageUrl: data.data,
                          ));
                        }
                      },
                    ),
                    SvgPicture.asset(
                      "images/small_camera.svg",
                    )
                  ],
                ),
              )),
          Column(
            children: <Widget>[
              baseItem(
                  () {},
                  "昵称",
                  StreamBuilder<String>(
                    stream: _model.nameLive.stream,
                    initialData: _model.nameLive.data,
                    builder: (con, data) {
                      return Center(
                        child: baseText(data.data ?? "", 13, 0xff323232),
                      );
                    },
                  ),
                  false),
              divideLine(),
              baseItem(
                  () {},
                  "国家",
                  StreamBuilder<String>(
                    stream: _model.cityLive.stream,
                    initialData: _model.cityLive.data,
                    builder: (con, data) {
                      return Container(
                        margin: EdgeInsets.only(
                            right: ScreenUtil.instance.setWidth(19)),
                        child: baseText(data.data ?? "", 13, 0xff323232),
                      );
                    },
                  ),
                  true),
              divideLine(),
              baseItem(() {
                jumpToComment(context, pageName());
              }, "意见与建议", null, true),
              divideLine(),
              baseItem(() {}, "隐私声明", null, true),
              divideLine(),
            ],
          ),
          Expanded(
            child: Container(),
          ),
          Container(
            width: double.maxFinite,
            height: 45,
            margin: EdgeInsets.only(
                bottom: ScreenUtil.instance.setHeight(30),
                left: ScreenUtil.instance.setWidth(30),
                right: ScreenUtil.instance.setWidth(30)),
            child: OutlineButton(
              onPressed: () {},
              child: baseText("退出登入", 14, 0xff323232),
              borderSide: new BorderSide(color: Color(0xff323232)),
            ),
          )
        ],
      ),
    );
  }

  divideLine() {
    return Container(
        height: 1,
        margin: EdgeInsets.only(
            right: ScreenUtil.instance.setWidth(30),
            left: ScreenUtil.instance.setWidth(30)),
        child: Container(
          color: Color(0xffE4E4E4),
        ));
  }

  baseItem(VoidCallback ontap, String left, Widget center, bool needRight) {
    return GestureDetector(
        onTap: () => ontap(),
        child: Container(
          margin: EdgeInsets.only(
              right: ScreenUtil.instance.setWidth(30),
              left: ScreenUtil.instance.setWidth(30)),
          height: 60,
          child: Row(
            children: <Widget>[
              baseText(left, 13, 0xff323232),
              Expanded(
                child: SizedBox(),
              ),
              center ?? Container(),
              needRight
                  ? SvgPicture.asset("images/right_arrow.svg")
                  : Container()
            ],
          ),
        ));
  }

  @override
  void reassemble() {
    super.reassemble();
    _model.dispose();
  }

  @override
  String pageName() {
    return "TODO";
  }

  @override
  String referrer() {
    return _model.refere;
  }
}
