/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/userModel/service/local/UserLocal.dart';
import 'package:gmalpha_flutter/userModel/service/remote/UserRemote.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.user.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserResultBean.dart';
import 'package:rxdart/rxdart.dart';

class UserRepository {
  UserRemote _remote;
  UserLocal _local;

  static UserRepository _userRepository;

  UserRepository._() {
    _remote = UserRemote.getInstance();
    _local = UserLocal.getInstance();
  }

  static UserRepository getInstance() {
    if (_userRepository == null) {
      _userRepository = UserRepository._();
    }
    return _userRepository;
  }

  Observable<UserResultBean> getUserInfo(String userId) {
    return _remote.getUserInfo(userId).map((value) {
      if (value != null) {
        _local.saveUserInfo(value);
      }
      return value;
    });
  }

  Observable<CommentBean> commentSuggest(String content, String phone) {
    return _remote.commentSuggest(content, phone);
  }
}
