/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/userModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.user.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserResultBean.dart';

class UserLocal {
  static UserLocal _userRemote;

  UserLocal._() {}

  static UserLocal getInstance() {
    if (_userRemote == null) {
      _userRemote = new UserLocal._();
    }
    return _userRemote;
  }

  void saveUserInfo(UserResultBean value) {
    if (value != null) {
      UserEntityImpl().saveuserId("${value.data.userId}");
      UserEntityImpl().savebirth(value.data.birth);
      UserEntityImpl().savecityId("${value.data.cityId}");
      UserEntityImpl().savecountryId("${value.data.countryInfo.id}");
      UserEntityImpl().savecountryInfoId("${value.data.countryInfo.id}");
      UserEntityImpl()
          .savecountryInfoLanguage("${value.data.countryInfo.language}");
      UserEntityImpl().savegender("${value.data.gender}");
      UserEntityImpl().savedetailSetted(value.data.detailSetted);
      UserEntityImpl().savecountryInfoName(value.data.countryInfo.name);
      UserEntityImpl().savehasAnswered(value.data.hasAnswered);
      UserEntityImpl().savehasScanFace(value.data.hasScanFace);
      UserEntityImpl().saveisBind(value.data.isBind);
      UserEntityImpl().savenickName(value.data.nickName);
      UserEntityImpl().saveprofilePic(value.data.profilePic);
      UserEntityImpl().savequestionUrl(value.data.questionUrl);
    }
  }
}
