/*
 * @author lsy
 * @date   2019-09-04
 **/
import 'package:gmalpha_flutter/commonModel/net/Responce/SimpleResponce.dart';
import 'package:gmalpha_flutter/userModel/service/remote/api/UserApi.serv.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/CommentBean.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/TestUserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserEntity.dart';
import 'package:gmalpha_flutter/userModel/service/remote/entity/UserResultBean.dart';
import 'package:rxdart/rxdart.dart';

class UserRemote {
  static UserRemote _userRemote;

  UserRemote._() {}

  static UserRemote getInstance() {
    if (_userRemote == null) {
      _userRemote = new UserRemote._();
    }
    return _userRemote;
  }

  Observable<UserResultBean> getUserInfo(String userID) {
    return UserApiImpl().getUserInfo(userID);
  }

  Observable<CommentBean> commentSuggest(String content, String phone) {
    return UserApiImpl().comment(content, phone);
  }
}
