import 'package:gmalpha_flutter/Annotations/anno/User.dart';
import 'package:gmalpha_flutter/Annotations/anno/UserCenter.dart';
import 'package:json_annotation/json_annotation.dart';

const String USER_ID = "user_uid";
const String NICKNAME = "username";
const String PORTRAIT = "potrait";
const String GENDER = "gender";
const String PERSONAL_QA = "personal_qa";
const String HAS_SCAN_FACE = "has_scan_face";
const String CURRENT_CITY_ID = "current_city_id";
const String QUESTION_URL = "question_url";
const String DETAIL_SETTED = "detail_setted";
const String BIRTHDAY = "birthday";
const String COUNTRY_ID = "country_id";
const String USER_BIND_MOBILE = "user_bind_mobile";
const String COUNTRY_LANGUAGE = "country_language";
const String COUNTRY_NAME = "country_name";

@UserCenter()
class UserEntity {
  /**
   * 用户id
   */
  @User(USER_ID, "")
  String userId;

  /**
   * 用户昵称
   */
  @User(NICKNAME, "")
  String nickName;

  /**
   * 用户头像
   */
  @User(PORTRAIT, "")
  String profilePic;

  /**
   * 是否需要答题
   */
  @User(PERSONAL_QA, true)
  bool hasAnswered = true;

  /**
   * 是否扫过脸
   */
  @User(HAS_SCAN_FACE, true)
  bool hasScanFace = false;

  String id;
  @User(GENDER, "")
  String gender;

  @User(CURRENT_CITY_ID, "")
  String cityId;

  @User(BIRTHDAY, 0.0)
  double birth;

  @User(COUNTRY_ID, "")
  String countryId;

  bool logined;

  // 用户是否设置过个人信息
  @User(DETAIL_SETTED, true)
  bool detailSetted = true;

  //用户是否选择了标签
  bool tagSetted = false;

  //注册流程中断后返回之前的登录页面
  @User(QUESTION_URL, "")
  String questionUrl;

  @User(USER_BIND_MOBILE, true)
  bool isBind;

  @User(COUNTRY_NAME, "")
  String countryInfoName;

  @User(COUNTRY_ID, "")
  String countryInfoId;

  @User(COUNTRY_LANGUAGE, "")
  String countryInfoLanguage;

  String insBindId;
  String registerTime;

  UserEntity(
      {this.userId,
      this.nickName,
      this.profilePic,
      this.hasAnswered,
      this.hasScanFace,
      this.id,
      this.gender,
      this.cityId,
      this.birth,
      this.countryId,
      this.logined,
      this.detailSetted,
      this.tagSetted,
      this.questionUrl,
      this.isBind,
      this.countryInfoName,
      this.countryInfoId,
      this.countryInfoLanguage,
      this.insBindId,
      this.registerTime});

  UserEntity.fromJson(Map<String, dynamic> json) {
    userId = json['user_id'];
    nickName = json['nick_name'];
    profilePic = json['profile_pic'];
    hasAnswered = json['has_answered'];
    hasScanFace = json['has_scan_face'];
    id = json['id'];
    gender = json['gender'];
    cityId = json['city_id'];
    birth = json['birth'];
    countryId = json['country_id'];
    logined = json['logined'];
    detailSetted = json['detail_setted'];
    tagSetted = json['tag_setted'];
    questionUrl = json['question_url'];
    isBind = json['is_bind'];
    countryInfoName = json['country_info_name'];
    countryInfoId = json['country_info_id'];
    countryInfoLanguage = json['country_info_language'];
    insBindId = json['ins_bind_id'];
    registerTime = json['register_time'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['user_id'] = this.userId;
    data['nick_name'] = this.nickName;
    data['profile_pic'] = this.profilePic;
    data['has_answered'] = this.hasAnswered;
    data['has_scan_face'] = this.hasScanFace;
    data['id'] = this.id;
    data['gender'] = this.gender;
    data['city_id'] = this.cityId;
    data['birth'] = this.birth;
    data['country_id'] = this.countryId;
    data['logined'] = this.logined;
    data['detail_setted'] = this.detailSetted;
    data['tag_setted'] = this.tagSetted;
    data['question_url'] = this.questionUrl;
    data['is_bind'] = this.isBind;
    data['country_info_name'] = this.countryInfoName;
    data['country_info_id'] = this.countryInfoId;
    data['country_info_language'] = this.countryInfoLanguage;
    data['ins_bind_id'] = this.insBindId;
    data['register_time'] = this.registerTime;
    return data;
  }
}
