/*
 * @author lsy
 * @date   2019-10-12
 **/
class UserResultBean {
  int error;
  String message;
  Null extra;
  Data data;
  UserType userType;

  UserResultBean(
      {this.error, this.message, this.extra, this.data, this.userType});

  UserResultBean.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    userType = json['user_type'] != null
        ? new UserType.fromJson(json['user_type'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    if (this.userType != null) {
      data['user_type'] = this.userType.toJson();
    }
    return data;
  }
}

class Data {
  int id;
  bool isOnline;
  int userId;
  String nickName;
  String profilePic;
  int gender;
  Null age;
  Null cityId;
  double birth;
  double registerTime;
  bool isBind;
  bool logined;
  bool hasAnswered;
  bool hasScanFace;
  Null insBindId;
  String questionUrl;
  bool detailSetted;
  CountryInfo countryInfo;
  String ageDisplay;
  bool tagSetted;
  bool hasSkinTexture;

  Data(
      {this.id,
      this.isOnline,
      this.userId,
      this.nickName,
      this.profilePic,
      this.gender,
      this.age,
      this.cityId,
      this.birth,
      this.registerTime,
      this.isBind,
      this.logined,
      this.hasAnswered,
      this.hasScanFace,
      this.insBindId,
      this.questionUrl,
      this.detailSetted,
      this.countryInfo,
      this.ageDisplay,
      this.tagSetted,
      this.hasSkinTexture});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isOnline = json['is_online'];
    userId = json['user_id'];
    nickName = json['nick_name'];
    profilePic = json['profile_pic'];
    gender = json['gender'];
    age = json['age'];
    cityId = json['city_id'];
    birth = json['birth'];
    registerTime = json['register_time'];
    isBind = json['is_bind'];
    logined = json['logined'];
    hasAnswered = json['has_answered'];
    hasScanFace = json['has_scan_face'];
    insBindId = json['ins_bind_id'];
    questionUrl = json['question_url'];
    detailSetted = json['detail_setted'];
    countryInfo = json['country_info'] != null
        ? new CountryInfo.fromJson(json['country_info'])
        : null;
    ageDisplay = json['age_display'];
    tagSetted = json['tag_setted'];
    hasSkinTexture = json['has_skin_texture'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['is_online'] = this.isOnline;
    data['user_id'] = this.userId;
    data['nick_name'] = this.nickName;
    data['profile_pic'] = this.profilePic;
    data['gender'] = this.gender;
    data['age'] = this.age;
    data['city_id'] = this.cityId;
    data['birth'] = this.birth;
    data['register_time'] = this.registerTime;
    data['is_bind'] = this.isBind;
    data['logined'] = this.logined;
    data['has_answered'] = this.hasAnswered;
    data['has_scan_face'] = this.hasScanFace;
    data['ins_bind_id'] = this.insBindId;
    data['question_url'] = this.questionUrl;
    data['detail_setted'] = this.detailSetted;
    if (this.countryInfo != null) {
      data['country_info'] = this.countryInfo.toJson();
    }
    data['age_display'] = this.ageDisplay;
    data['tag_setted'] = this.tagSetted;
    data['has_skin_texture'] = this.hasSkinTexture;
    return data;
  }
}

class CountryInfo {
  String name;
  String id;
  String language;

  CountryInfo({this.name, this.id, this.language});

  CountryInfo.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    id = json['id'];
    language = json['language'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['id'] = this.id;
    data['language'] = this.language;
    return data;
  }
}

class UserType {
  UserType();

  UserType.fromJson(Map<String, dynamic> json) {}

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    return data;
  }
}
