import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'Home/HomePage.dart';
import 'Message/MessagePage.dart';
import 'Mine/MinePage.dart';
import 'Order/OrderPage.dart';

void main() => runApp(App());

class App extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        initialRoute: '/',
        routes: {
          '/': (context) => Home(),
        },
        theme: ThemeData(
          primarySwatch: Colors.yellow,
          highlightColor: Color.fromRGBO(255, 255, 255, 0.5),
          splashColor: Colors.white70,
          accentColor: Color.fromRGBO(3, 54, 255, 1.0),
        ));
  }
}

class Home extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => new HomeState();
}

class HomeState extends State<Home> {
  final appBarTitles = ['首页', '订单', '消息', '我'];
  final tabTextStyleSelected = new TextStyle(color: const Color(0xff333333));
  final tabTextStyleNormal = new TextStyle(color: const Color(0xff666666));
  int _tabIndex = 0;
  var tabImages;
  var _body;
  var pages;

  TextStyle getTabTextStyle(int curIndex) {
    if (curIndex == _tabIndex) {
      return tabTextStyleSelected;
    }
    return tabTextStyleNormal;
  }

  Image getTabIcon(int curIndex) {
    if (curIndex == _tabIndex) {
      return tabImages[curIndex][1];
    }
    return tabImages[curIndex][0];
  }

  Image getTabImage(path) {
    return new Image.asset(path, width: 40.0, height: 40.0);
  }

  @override
  void initState() {
    super.initState();
    pages = <Widget>[
      new HomePage(),
      new OrderPage(),
      new MessagePage(),
      new MinePage()
    ];
    if (tabImages == null) {
      tabImages = [
        [
          getTabImage('images/menu_home.png'),
          getTabImage('images/menu_home_pr.png')
        ],
        [
          getTabImage('images/menu_order.png'),
          getTabImage('images/menu_order_pr.png')
        ],
        [
          getTabImage('images/menu_message.png'),
          getTabImage('images/menu_message_pr.png')
        ],
        [
          getTabImage('images/menu_me.png'),
          getTabImage('images/menu_me_pr.png')
        ]
      ];
    }
  }

  Text getTabTitle(int curIndex) {
    return new Text(appBarTitles[curIndex], style: getTabTextStyle(curIndex));
  }
  
  @override
  Widget build(BuildContext context) {
    _body = new IndexedStack(
      children: pages,
      index: _tabIndex,
    );
    return DefaultTabController(
      length: 4,
      child: Scaffold(
        appBar: AppBar(
          title: Text('首页'),
          actions: <Widget>[
            IconButton(
              icon: Icon(Icons.search),
              tooltip: 'Search',
              onPressed: () => debugPrint('Search button is pressed.'),
            )
          ],
          elevation: 0.0,
        ),
        body: _body,
        bottomNavigationBar: new CupertinoTabBar(
          items: <BottomNavigationBarItem>[
            new BottomNavigationBarItem(
                icon: getTabIcon(0),
                title: getTabTitle(0)),
            new BottomNavigationBarItem(
                icon: getTabIcon(1),
                title: getTabTitle(1)),
            new BottomNavigationBarItem(
                icon: getTabIcon(2),
                title: getTabTitle(2)),
            new BottomNavigationBarItem(
                icon: getTabIcon(3),
                title: getTabTitle(3)),
          ],
          currentIndex: _tabIndex,
          onTap: (index) {
            setState((){
              _tabIndex = index;
            });
          },
        ),
      ),
    );
  }
}
