# 更美数据库设计开发规范 - 试行版
## MySQL
### 数据库整体设计规范(必读)
#### 库表涉及与使用
1. 一般都使用 INNODB 存储引擎，除非读写比率<1%,才考虑使用 MYISAM 存储引擎；其他存储引擎请在运维\DBA的建议下使用。
2. Stored procedure （包括存储过程，函数，触发器）不建议使用。
3. 请不要使用外键约束，如果数据存在外键关系，请在程序层面实现。 （？？？） 
4. 如果应用使用的是长连接，应用必须具有自动重连的机制。但请避免每执行一个 SQL去检查一次 DB 可用性。
5. 如果应用使用的是长连接，应用应该具有连接的 TIMEOUT 检查机制，及时回收长时间没有使用的连接。 TIMEOUT 时间一般建议为 20min。
6. 我们所有的 MySQL 数据库除历史原因外，都采用 UTF8MB4 编码。
8. 原则上，Mysql用户名与数据库名字一样。涉及到各端使用相同db的，各自使用独立账户。 

#### 命名
1. 命名应使用富有意义的英文词汇，多个单词组成的，中间以下划线分割。
2. 命名只能使用英文字母，数字和下划线。
3. 命名避免使用 Mysql 的保留字（详见附录 A）和系统关键字。
4. 命名长度以不超过 15 个字符为宜(避免超过 20)。
5. 命名全部采用小写，并且名称前后不能加引号。


### 数据库对象设计规范
#### 1. 表
##### 表设计

1. 在设计时尽量包含两个日期字段:gmt_created(创建日期),gmt_modified(修改日期)且非空, 对表的记录进行更新的时候，必须包含对 gmt_modified 字段的更新。datetime, timestamp?
2. 必须要有主键，主键尽量用自增字段类型，推荐类型为 INT 或者 BIGINT 类型。
3. 需要多表 join 的字段，数据类型保持绝对一致。
4. 当表的字段数非常多时，可以将表分成两张表，一张作为条件查询表，一张作为详细内容表（主要是为了性能考虑）。case by case
5. 当字段的类型为枚举型或布尔型时，建议使用 char(1)类型。??
6. 同一表中，所有 varchar 字段的长度加起来，不能大于 65535.如果有这样的需求，请使用 TEXT/LONGTEXT 类型。

##### 表命名
> 业务团队同学共同参与制定

参考：
1. 同一个模块的表尽可能使用相同的前缀，表名尽可能表达含义，例如：CRM_SAL_FUND_ITEM。
2. 字段命名应尽可能使用表达实际含义的英文单词或缩写，
    如，公司 ID，不要使用：corporation_id, 而用：corp_id 即可。
3. 布尔值类型的字段命名为 is+描述。如 member 表上表示是否为 enabled 的会员的字段命名为 IsEnabled


##### 字段类型

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ggsolsj9fmj30g10tbjs3.jpg)


##### 字段注释
- 新增列、新建表，务必增加字段注释

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ggsonreafij30hd0u2751.jpg)


#### 2. 索引
##### 设计


##### 命名
1. 普通索引使用idx_  
2. 唯一索引使用uniq_开头





### SQL开发规范
#### 1. 编码&格式规范

1. 表与表的关联只使用左连接和全连接，避免使用右连接，保证主表在前，从表在后的顺序，按照从左向右的思维逻辑，方便SQL业务逻辑的阅读

2. 代码中SQL关键字保证右对齐，这样SQL中的字段就能保证左对齐

3. 同一级别的表关联，左侧缩进一致，并保证关键字右对齐

4. 在同一个变更中，不要同时进行DDL和DML




## 规范收集箱
1 不允许drop table / column 
2 禁止在create table语句中指定字符集为utf8。我们所有环境mysql指定字符集为utf8mb4 存储引擎为innodb
3 sql create table / alter column 需要有注释
字段"business_id"与参数类型不匹配,隐式转换会导致条件不能使用索引
