# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-04-11 03:35
from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone


def migrate_node_permissions(apps, schema_editor):
    node_perm_model = apps.get_model("perms", "NodePermission")
    asset_perm_model = apps.get_model("perms", "AssetPermission")
    db_alias = schema_editor.connection.alias
    for old in node_perm_model.objects.using(db_alias).all():
        perm = asset_perm_model.objects.using(db_alias).create(
            name="{}-{}-{}".format(
                old.node.value,
                old.user_group.name,
                old.system_user.name
            ),
            is_active=old.is_active,
            date_expired=old.date_expired,
            created_by=old.date_expired,
            date_created=old.date_created,
            comment=old.comment,
        )
        perm.user_groups.add(old.user_group)
        perm.nodes.add(old.node)
        perm.system_users.add(old.system_user)


def migrate_system_assets_relation(apps, schema_editor):
    system_user_model = apps.get_model("assets", "SystemUser")
    db_alias = schema_editor.connection.alias
    for s in system_user_model.objects.using(db_alias).all():
        nodes = list(s.nodes.all())
        s.nodes.set([])
        s.nodes.set(nodes)


class Migration(migrations.Migration):

    dependencies = [
        ('perms', '0004_auto_20180411_1135'),
    ]

    operations = [
        migrations.RunPython(migrate_node_permissions),
        migrations.RunPython(migrate_system_assets_relation),
    ]
