# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-02-25 10:15
from __future__ import unicode_literals

import common.utils
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0004_auto_20180125_1218'),
        ('assets', '0007_auto_20180225_1815'),
        ('perms', '0002_auto_20171228_0025'),
    ]

    operations = [
        migrations.CreateModel(
            name='NodePermission',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('date_expired', models.DateTimeField(default=common.utils.date_expired_default, verbose_name='Date expired')),
                ('created_by', models.CharField(blank=True, max_length=128, verbose_name='Created by')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assets.Node', verbose_name='Node')),
                ('system_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assets.SystemUser', verbose_name='System user')),
                ('user_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.UserGroup', verbose_name='User group')),
            ],
            options={
                'verbose_name': 'Asset permission',
            },
        ),
        migrations.AlterUniqueTogether(
            name='nodepermission',
            unique_together=set([('node', 'user_group', 'system_user')]),
        ),
    ]
