# coding:utf-8
from django.conf.urls import url
from .. import api
from rest_framework_bulk.routes import BulkRouter

app_name = 'assets'


router = BulkRouter()
router.register(r'assets', api.AssetViewSet, 'asset')
router.register(r'admin-user', api.AdminUserViewSet, 'admin-user')
router.register(r'system-user', api.SystemUserViewSet, 'system-user')
router.register(r'labels', api.LabelViewSet, 'label')
router.register(r'nodes', api.NodeViewSet, 'node')
router.register(r'domain', api.DomainViewSet, 'domain')
router.register(r'gateway', api.GatewayViewSet, 'gateway')

urlpatterns = [
    url(r'^assets-bulk/$', api.AssetListUpdateApi.as_view(), name='asset-bulk-update'),
    url(r'^system-user/(?P<pk>[0-9a-zA-Z\-]{36})/auth-info/', api.SystemUserAuthInfoApi.as_view(),
        name='system-user-auth-info'),
    url(r'^assets/(?P<pk>[0-9a-zA-Z\-]{36})/refresh/$',
        api.AssetRefreshHardwareApi.as_view(), name='asset-refresh'),
    url(r'^assets/(?P<pk>[0-9a-zA-Z\-]{36})/alive/$',
        api.AssetAdminUserTestApi.as_view(), name='asset-alive-test'),
    url(r'^assets/(?P<pk>[0-9a-zA-Z\-]{36})/gateway/$',
        api.AssetGatewayApi.as_view(), name='asset-gateway'),
    url(r'^admin-user/(?P<pk>[0-9a-zA-Z\-]{36})/nodes/$',
        api.ReplaceNodesAdminUserApi.as_view(), name='replace-nodes-admin-user'),
    url(r'^admin-user/(?P<pk>[0-9a-zA-Z\-]{36})/auth/$',
        api.AdminUserAuthApi.as_view(), name='admin-user-auth'),
    url(r'^admin-user/(?P<pk>[0-9a-zA-Z\-]{36})/connective/$',
        api.AdminUserTestConnectiveApi.as_view(), name='admin-user-connective'),
    url(r'^system-user/(?P<pk>[0-9a-zA-Z\-]{36})/push/$',
        api.SystemUserPushApi.as_view(), name='system-user-push'),
    url(r'^system-user/(?P<pk>[0-9a-zA-Z\-]{36})/connective/$',
        api.SystemUserTestConnectiveApi.as_view(), name='system-user-connective'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/children/$',
        api.NodeChildrenApi.as_view(), name='node-children'),
    url(r'^nodes/children/$', api.NodeChildrenApi.as_view(), name='node-children-2'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/children/add/$',
        api.NodeAddChildrenApi.as_view(), name='node-add-children'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/assets/$',
        api.NodeAssetsApi.as_view(), name='node-assets'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/assets/add/$',
        api.NodeAddAssetsApi.as_view(), name='node-add-assets'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/assets/replace/$',
        api.NodeReplaceAssetsApi.as_view(), name='node-replace-assets'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/assets/remove/$',
        api.NodeRemoveAssetsApi.as_view(), name='node-remove-assets'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/refresh-hardware-info/$',
        api.RefreshNodeHardwareInfoApi.as_view(), name='node-refresh-hardware-info'),
    url(r'^nodes/(?P<pk>[0-9a-zA-Z\-]{36})/test-connective/$',
        api.TestNodeConnectiveApi.as_view(), name='node-test-connective'),

    url(r'^gateway/(?P<pk>[0-9a-zA-Z\-]{36})/test-connective/$',
        api.GatewayTestConnectionApi.as_view(), name='test-gateway-connective'),
]

urlpatterns += router.urls

