# coding: utf-8

from django.shortcuts import render_to_response
from django.http import HttpResponseRedirect, HttpResponse
from django.template import RequestContext
from juser.models import User, UserGroup, DEPT
from jasset.models import Asset, BisGroup
from jperm.models import Perm, SudoPerm, CmdGroup
from django.core.paginator import Paginator, EmptyPage, InvalidPage
from django.db.models import Q
from jumpserver.views import LDAP_ENABLE, ldap_conn, CONF, page_list_return, pages
from jumpserver.api import *


def asset_cmd_groups_get(asset_groups_select='', cmd_groups_select=''):
    asset_groups_select_list = []
    cmd_groups_select_list = []

    for asset_group_id in asset_groups_select:
        asset_groups_select_list.extend(BisGroup.objects.filter(id=asset_group_id))

    for cmd_group_id in cmd_groups_select:
        cmd_groups_select_list.extend(CmdGroup.objects.filter(id=cmd_group_id))

    return asset_groups_select_list, cmd_groups_select_list


@require_admin
def perm_add(request):
    header_title, path1, path2 = u'主机授权添加', u'授权管理', u'授权添加'

    if request.method == 'GET':
        user_groups = UserGroup.objects.filter(id__gt=2)
        asset_groups = BisGroup.objects.all()

    else:
        name = request.POST.get('name', '')
        user_groups_select = request.POST.getlist('user_groups_select')
        asset_groups_select = request.POST.getlist('asset_groups_select')
        comment = request.POST.get('comment', '')

        user_groups, asset_groups = user_asset_cmd_groups_get(user_groups_select, asset_groups_select, '')[0:2]

        perm = Perm(name=name, comment=comment)
        perm.save()

        perm.user_group = user_groups
        perm.asset_group = asset_groups
        msg = '添加成功'
    return render_to_response('jperm/perm_add.html', locals(), context_instance=RequestContext(request))


def dept_add_asset(dept_id, asset_list):
    dept = DEPT.objects.filter(id=dept_id)
    if dept:
        dept = dept[0]
        new_perm_asset = []
        for asset_id in asset_list:
            asset = Asset.objects.filter(id=asset_id)
            new_perm_asset.extend(asset)

        dept.asset_set.clear()
        dept.asset_set = new_perm_asset


@require_super_user
def dept_perm_edit(request):
    header_title, path1, path2 = u'部门授权添加', u'授权管理', u'部门授权添加'
    if request.method == 'GET':
        dept_id = request.GET.get('id', '')
        dept = DEPT.objects.filter(id=dept_id)
        if dept:
            dept = dept[0]
            asset_all = Asset.objects.all()
            asset_select = dept.asset_set.all()
            assets = [asset for asset in asset_all if asset not in asset_select]
    else:
        dept_id = request.POST.get('dept_id')
        asset_select = request.POST.getlist('asset_select')
        dept_add_asset(dept_id, asset_select)
        return HttpResponseRedirect('/jperm/dept_perm_list/')
    return render_to_response('jperm/dept_perm_edit.html', locals(), context_instance=RequestContext(request))


@require_super_user
def perm_list(request):
    header_title, path1, path2 = u'小组授权', u'授权管理', u'授权详情'
    keyword = request.GET.get('search', '')
    if keyword:
        contact_list = UserGroup.objects.filter(Q(name__icontains=keyword) | Q(comment__icontains=keyword))
    else:
        contact_list = UserGroup.objects.all().order_by('name')

    contact_list, p, contacts, page_range, current_page, show_first, show_end = pages(contact_list, request)
    return render_to_response('jperm/perm_list.html', locals(), context_instance=RequestContext(request))


@require_admin
def perm_list_adm(request):
    header_title, path1, path2 = u'小组授权', u'授权管理', u'授权详情'
    keyword = request.GET.get('search', '')
    user, dept = get_session_user_dept(request)
    contact_list = dept.usergroup_set.all().order_by('name')
    if keyword:
        contact_list = contact_list.filter(Q(name__icontains=keyword) | Q(comment__icontains=keyword))

    contact_list, p, contacts, page_range, current_page, show_first, show_end = pages(contact_list, request)
    return render_to_response('jperm/perm_list.html', locals(), context_instance=RequestContext(request))


@require_super_user
def dept_perm_list(request):
    header_title, path1, path2 = '查看部门', '授权管理', '部门授权'
    keyword = request.GET.get('search')
    if keyword:
        contact_list = DEPT.objects.filter(Q(name__icontains=keyword) | Q(comment__icontains=keyword)).order_by('name')
    else:
        contact_list = DEPT.objects.filter(id__gt=1)

    contact_list, p, contacts, page_range, current_page, show_first, show_end = pages(contact_list, request)

    return render_to_response('jperm/dept_perm_list.html', locals(), context_instance=RequestContext(request))


def perm_group_update(user_group_id, asset_groups_id_list):
    user_group = UserGroup.objects.filter(id=user_group_id)
    if user_group:
        user_group = user_group[0]
        old_asset_group = [perm.asset_group for perm in user_group.perm_set.all()]
        new_asset_group = []

        for asset_group_id in asset_groups_id_list:
            new_asset_group.extend(BisGroup.objects.filter(id=asset_group_id))

        del_asset_group = [asset_group for asset_group in old_asset_group if asset_group not in new_asset_group]
        add_asset_group = [asset_group for asset_group in new_asset_group if asset_group not in old_asset_group]

        for asset_group in del_asset_group:
            Perm.objects.filter(user_group=user_group, asset_group=asset_group).delete()

        for asset_group in add_asset_group:
            Perm(user_group=user_group, asset_group=asset_group).save()


@require_super_user
def perm_edit(request):
    if request.method == 'GET':
        header_title, path1, path2 = u'编辑授权', u'授权管理', u'授权编辑'
        user_group_id = request.GET.get('id', '')
        user_group = UserGroup.objects.filter(id=user_group_id)
        if user_group:
            user_group = user_group[0]
            asset_groups_all = BisGroup.objects.all()
            asset_groups_select = [perm.asset_group for perm in user_group.perm_set.all()]
            asset_groups = [asset_group for asset_group in asset_groups_all if asset_group not in asset_groups_select]
    else:
        user_group_id = request.POST.get('user_group_id')
        asset_group_id_list = request.POST.getlist('asset_groups_select')
        perm_group_update(user_group_id, asset_group_id_list)

        return HttpResponseRedirect('/jperm/perm_list/')
    return render_to_response('jperm/perm_edit.html', locals(), context_instance=RequestContext(request))


@require_admin
def perm_edit_adm(request):
    if request.method == 'GET':
        header_title, path1, path2 = u'编辑授权', u'授权管理', u'授权编辑'
        user_group_id = request.GET.get('id', '')
        user_group = UserGroup.objects.filter(id=user_group_id)
        user, dept = get_session_user_dept(request)
        if user_group:
            user_group = user_group[0]
            asset_groups_all = dept.bisgroup_set.all()
            asset_groups_select = [perm.asset_group for perm in user_group.perm_set.all()]
            asset_groups = [asset_group for asset_group in asset_groups_all if asset_group not in asset_groups_select]
    else:
        user_group_id = request.POST.get('user_group_id')
        asset_group_id_list = request.POST.getlist('asset_groups_select')
        if not validate(request, user_group=[user_group_id], asset_group=asset_group_id_list):
            return HttpResponseRedirect('/jperm/perm_list/')
        perm_group_update(user_group_id, asset_group_id_list)

        return HttpResponseRedirect('/jperm/perm_list/')
    return render_to_response('jperm/perm_edit.html', locals(), context_instance=RequestContext(request))

@require_admin
def perm_detail(request):
    header_title, path1, path2 = u'编辑授权', u'授权管理', u'授权详情'
    perm_id = request.GET.get('id')
    perm = Perm.objects.filter(id=perm_id)
    if perm:
        perm = perm[0]
        user_groups = perm.user_group.all()
        asset_groups = perm.asset_group.all()

        users_list = []
        assets_list = []

        for user_group in user_groups:
            users_list.extend(user_group.user_set.all())
        for asset_group in asset_groups:
            assets_list.extend(asset_group.asset_set.all())

    return render_to_response('jperm/perm_detail.html', locals(), context_instance=RequestContext(request))


@require_admin
def perm_del(request):
    perm_id = request.GET.get('id')
    perm = Perm.objects.filter(id=perm_id)
    if perm:
        perm = perm[0]
        perm.delete()
    return HttpResponseRedirect('/jperm/perm_list/')


@require_admin
def perm_asset_detail(request):
    header_title, path1, path2 = u'用户授权主机', u'权限管理', u'用户主机详情'
    user_id = request.GET.get('id')
    user = User.objects.filter(id=user_id)
    if user:
        user = user[0]
        assets_list = user_perm_asset_api(user.username)
    return render_to_response('jperm/perm_asset_detail.html', locals(), context_instance=RequestContext(request))


# def sudo_db_add(name, user_runas, user_groups_select, asset_groups_select, cmd_groups_select, comment):
#     user_groups_select_list, asset_groups_select_list, cmd_groups_select_list = \
#         user_asset_cmd_groups_get(user_groups_select, asset_groups_select, cmd_groups_select)
#
#     sudo_perm = SudoPerm(name=name, user_runas=user_runas, comment=comment)
#     sudo_perm.save()
#     sudo_perm.user_group = user_groups_select_list
#     sudo_perm.asset_group = asset_groups_select_list
#     sudo_perm.cmd_group = cmd_groups_select_list


def unicode2str(unicode_list):
    return [str(i) for i in unicode_list]


def sudo_ldap_add(user_group, user_runas, asset_groups_select,
                  cmd_groups_select):

    if not LDAP_ENABLE:
        return True

    assets = []
    cmds = []
    user_runas = user_runas.split(',')
    if len(asset_groups_select) == 1 and asset_groups_select[0].name == 'ALL':
        asset_all = True
    else:
        asset_all = False
        for asset_group in asset_groups_select:
            assets.extend(asset_group.asset_set.all())

    if user_group.name == 'ALL':
        user_all = True
        users = []
    else:
        user_all = False
        users = user_group.user_set.all()

    for cmd_group in cmd_groups_select:
        cmds.extend(cmd_group.cmd.split(','))

    if user_all:
        users_name = ['ALL']
    else:
        users_name = list(set([user.username for user in users]))

    if asset_all:
        assets_ip = ['ALL']
    else:
        assets_ip = list(set([asset.ip for asset in assets]))

    name = 'sudo%s' % user_group.id
    sudo_dn = 'cn=%s,ou=Sudoers,%s' % (name, LDAP_BASE_DN)
    sudo_attr = {'objectClass': ['top', 'sudoRole'],
                 'cn': ['%s' % name],
                 'sudoCommand': unicode2str(cmds),
                 'sudoHost': unicode2str(assets_ip),
                 'sudoOption': ['!authenticate'],
                 'sudoRunAsUser': unicode2str(user_runas),
                 'sudoUser': unicode2str(users_name)}
    print sudo_dn
    ldap_conn.delete(sudo_dn)
    ldap_conn.add(sudo_dn, sudo_attr)


def sudo_update(user_group, user_runas, asset_groups_select, cmd_groups_select, comment):
    asset_groups_select_list, cmd_groups_select_list = \
        asset_cmd_groups_get(asset_groups_select, cmd_groups_select)
    sudo_perm = user_group.sudoperm_set.all()
    if sudo_perm:
        sudo_perm.update(user_runas=user_runas, comment=comment)
        sudo_perm = sudo_perm[0]
        sudo_perm.asset_group = asset_groups_select_list
        sudo_perm.cmd_group = cmd_groups_select_list
    else:
        sudo_perm = SudoPerm(user_group=user_group, user_runas=user_runas, comment=comment)
        sudo_perm.save()
        sudo_perm.asset_group = asset_groups_select_list
        sudo_perm.cmd_group = cmd_groups_select_list

    sudo_ldap_add(user_group, user_runas, asset_groups_select_list, cmd_groups_select_list)


# @require_super_user
# def sudo_add(request):
#     header_title, path1, path2 = u'Sudo授权', u'权限管理', u'添加Sudo权限'
#     user_groups = UserGroup.objects.filter(id__gt=2)
#     asset_groups = BisGroup.objects.all()
#     cmd_groups = CmdGroup.objects.all()
#
#     if request.method == 'POST':
#         name = request.POST.get('name')
#         users_runas = request.POST.get('runas', 'root')
#         user_groups_select = request.POST.getlist('user_groups_select')
#         asset_groups_select = request.POST.getlist('asset_groups_select')
#         cmd_groups_select = request.POST.getlist('cmd_groups_select')
#         comment = request.POST.get('comment', '')
#
#         if LDAP_ENABLE:
#             sudo_db_add(name, users_runas, user_groups_select, asset_groups_select, cmd_groups_select, comment)
#             sudo_ldap_add(name, users_runas, user_groups_select, asset_groups_select, cmd_groups_select)
#
#         msg = '添加成功'
#     return render_to_response('jperm/sudo_add.html', locals(), context_instance=RequestContext(request))


# @require_admin
# def sudo_add_adm(request):
#     header_title, path1, path2 = u'Sudo授权', u'权限管理', u'添加Sudo权限'
#     user, dept = get_session_user_dept(request)
#     user_groups = dept.usergroup_set.filter(id__gt=2)
#     asset_groups = dept.bisgroup_set.all()
#     cmd_groups = CmdGroup.objects.all()
#
#     if request.method == 'POST':
#         name = request.POST.get('name')
#         users_runas = request.POST.get('runas', 'root')
#         user_groups_select = request.POST.getlist('user_groups_select')
#         asset_groups_select = request.POST.getlist('asset_groups_select')
#         cmd_groups_select = request.POST.getlist('cmd_groups_select')
#         comment = request.POST.get('comment', '')
#
#         if LDAP_ENABLE:
#             sudo_db_add(name, users_runas, user_groups_select, asset_groups_select, cmd_groups_select, comment)
#             sudo_ldap_add(name, users_runas, user_groups_select, asset_groups_select, cmd_groups_select)
#
#         msg = '添加成功'
#     return render_to_response('jperm/sudo_add.html', locals(), context_instance=RequestContext(request))


@require_admin
def sudo_list(request):
    header_title, path1, path2 = u'Sudo授权', u'权限管理', u'Sudo权限详情'
    keyword = request.GET.get('search', '')
    if keyword:
        contact_list = UserGroup.objects.filter(Q(name__icontains=keyword) | Q(comment__icontains=keyword))
    else:
        contact_list = UserGroup.objects.all().order_by('name')

    contact_list, p, contacts, page_range, current_page, show_first, show_end = pages(contact_list, request)
    return render_to_response('jperm/sudo_list.html', locals(), context_instance=RequestContext(request))


@require_super_user
def sudo_edit(request):
    header_title, path1, path2 = u'Sudo授权', u'授权管理', u'Sudo授权'

    if request.method == 'GET':
        user_group_id = request.GET.get('id', '0')
        user_group = UserGroup.objects.filter(id=user_group_id)
        asset_group_all = BisGroup.objects.filter()
        cmd_group_all = CmdGroup.objects.all()
        if user_group:
            user_group = user_group[0]
            sudo_perm = user_group.sudoperm_set.all()
            if sudo_perm:
                sudo_perm = sudo_perm[0]
                asset_group_permed = sudo_perm.asset_group.all()
                cmd_group_permed = sudo_perm.cmd_group.all()
                user_runas = sudo_perm.user_runas
                comment = sudo_perm.comment
            else:
                asset_group_permed = []
                cmd_group_permed = []

            asset_groups = [asset_group for asset_group in asset_group_all if asset_group not in asset_group_permed]
            cmd_groups = [cmd_group for cmd_group in cmd_group_all if cmd_group not in cmd_group_permed]

    else:
        user_group_id = request.POST.get('user_group_id', '')
        users_runas = request.POST.get('runas', 'root')
        asset_groups_select = request.POST.getlist('asset_groups_select')
        cmd_groups_select = request.POST.getlist('cmd_groups_select')
        comment = request.POST.get('comment', '')
        user_group = UserGroup.objects.filter(id=user_group_id)
        if user_group:
            user_group = user_group[0]
            if LDAP_ENABLE:
                sudo_update(user_group, users_runas, asset_groups_select, cmd_groups_select, comment)
                msg = '修改成功'

        return HttpResponseRedirect('/jperm/sudo_list/')

    return render_to_response('jperm/sudo_edit.html', locals(), context_instance=RequestContext(request))


@require_admin
def sudo_refresh(request):
    sudo_perm_all = SudoPerm.objects.all()
    for sudo_perm in sudo_perm_all:
        user_group = sudo_perm.user_group
        user_runas = sudo_perm.user_runas
        asset_groups_select = sudo_perm.asset_group.all()
        cmd_groups_select = sudo_perm.cmd_group.all()
        sudo_ldap_add(user_group, user_runas, asset_groups_select, cmd_groups_select)
    return HttpResponse('ok')

# @require_admin
# def sudo_detail(request):
#     header_title, path1, path2 = u'Sudo授权详情', u'授权管理', u'授权详情'
#     sudo_perm_id = request.GET.get('id')
#     sudo_perm = SudoPerm.objects.filter(id=sudo_perm_id)
#     if sudo_perm:
#         sudo_perm = sudo_perm[0]
#         user_groups = sudo_perm.user_group.all()
#         asset_groups = sudo_perm.asset_group.all()
#         cmd_groups = sudo_perm.cmd_group.all()
#
#         users_list = []
#         assets_list = []
#         cmds_list = []
#
#         for user_group in user_groups:
#             users_list.extend(user_group.user_set.all())
#         for asset_group in asset_groups:
#             assets_list.extend(asset_group.asset_set.all())
#         for cmd_group in cmd_groups:
#             cmds_list.append({cmd_group.name: cmd_group.cmd.split(',')})
#
#         return render_to_response('jperm/sudo_detail.html', locals(), context_instance=RequestContext(request))


# @require_admin
# def sudo_del(request):
#     sudo_perm_id = request.GET.get('id', '0')
#     sudo_perm = SudoPerm.objects.filter(id=int(sudo_perm_id))
#     if sudo_perm:
#         name = sudo_perm[0].name
#         sudo_perm.delete()
#         sudo_dn = 'cn=%s,ou=Sudoers,%s' % (name, LDAP_BASE_DN)
#         ldap_conn.delete(sudo_dn)
#     return HttpResponseRedirect('/jperm/sudo_list/')


@require_admin
def cmd_add(request):
    header_title, path1, path2 = u'sudo命令添加', u'授权管理', u'命令组添加'
    dept_all = DEPT.objects.all()

    if request.method == 'POST':
        name = request.POST.get('name')
        dept_id = request.POST.get('dept_id')
        cmd = ','.join(request.POST.get('cmd').split())
        comment = request.POST.get('comment')

        dept = DEPT.objects.filter(id=dept_id)
        if dept:
            dept = dept[0]
            CmdGroup.objects.create(name=name, dept=dept, cmd=cmd, comment=comment)
        else:
            error = u"部门不能为空"
        msg = u'命令组添加成功'

        return HttpResponseRedirect('/jperm/cmd_list/')

    return render_to_response('jperm/sudo_cmd_add.html', locals(), context_instance=RequestContext(request))


@require_admin
def cmd_edit(request):
    header_title, path1, path2 = u'sudo命令修改', u'授权管理管理', u'命令组修改'

    cmd_group_id = request.GET.get('id')
    cmd_group = CmdGroup.objects.filter(id=cmd_group_id)

    if cmd_group:
        cmd_group = cmd_group[0]
        cmd_group_id = cmd_group.id
        name = cmd_group.name
        cmd = '\n'.join(cmd_group.cmd.split(','))
        comment = cmd_group.comment

    if request.method == 'POST':
        cmd_group_id = request.POST.get('cmd_group_id')
        name = request.POST.get('name')
        cmd = ','.join(request.POST.get('cmd').split())
        comment = request.POST.get('comment')

        cmd_group = CmdGroup.objects.filter(id=cmd_group_id)
        if cmd_group:
            cmd_group.update(name=name, cmd=cmd, comment=comment)
            return HttpResponseRedirect('/jperm/cmd_list/')
    return render_to_response('jperm/sudo_cmd_add.html', locals(), context_instance=RequestContext(request))


@require_admin
def cmd_list(request):
    header_title, path1, path2 = u'sudo命令查看', u'权限管理', u'Sudo命令添加'

    cmd_groups = contact_list = CmdGroup.objects.all()
    p = paginator = Paginator(contact_list, 10)

    try:
        page = int(request.GET.get('page', '1'))
    except ValueError:
        page = 1

    try:
        contacts = paginator.page(page)
    except (EmptyPage, InvalidPage):
        contacts = paginator.page(paginator.num_pages)
    return render_to_response('jperm/sudo_cmd_list.html', locals(), context_instance=RequestContext(request))


@require_admin
def cmd_del(request):
    cmd_group_id = request.GET.get('id')
    cmd_group = CmdGroup.objects.filter(id=cmd_group_id)

    if cmd_group:
        cmd_group[0].delete()
    return HttpResponseRedirect('/jperm/cmd_list/')
