# Generated by Django 2.1.7 on 2019-09-16 02:57

from django.db import migrations, models


def migrate_system_user_from_remote_app_to_remote_app_perms(apps, schema_editor):
    remote_app_perms_model = apps.get_model("perms", "RemoteAppPermission")
    db_alias = schema_editor.connection.alias
    perms = remote_app_perms_model.objects.using(db_alias).all()
    for perm in perms:
        system_users_ids = perm.remote_apps.values_list('system_user', flat=True)
        perm.system_users.set(system_users_ids)


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0038_auto_20190911_1634'),
        ('perms', '0008_auto_20190911_1907'),
    ]

    operations = [
        migrations.AddField(
            model_name='remoteapppermission',
            name='system_users',
            field=models.ManyToManyField(related_name='granted_by_remote_app_permissions', to='assets.SystemUser', verbose_name='System user'),
        ),
        migrations.RunPython(
            code=migrate_system_user_from_remote_app_to_remote_app_perms,
        ),
    ]
