from drf_yasg.inspectors import SwaggerAutoSchema

from rest_framework import permissions
from drf_yasg.views import get_schema_view
from drf_yasg import openapi


class CustomSwaggerAutoSchema(SwaggerAutoSchema):
    def get_tags(self, operation_keys):
        if len(operation_keys) > 2:
            return [operation_keys[0] + '_' + operation_keys[1]]
        return super().get_tags(operation_keys)

    def get_operation_id(self, operation_keys):
        action = ''
        dump_keys = [k for k in operation_keys]
        if hasattr(self.view, 'action'):
            action = self.view.action
            if action == "bulk_destroy":
                action = "bulk_delete"
        if dump_keys[-2] == "children":
            if self.path.find('id') < 0:
                dump_keys.insert(-2, "root")
        if dump_keys[0] == "perms" and dump_keys[1] == "users":
            if self.path.find('{id}') < 0:
                dump_keys.insert(2, "my")
        if action.replace('bulk_', '') == dump_keys[-1]:
            dump_keys[-1] = action
        return super().get_operation_id(tuple(dump_keys))

    def get_operation(self, operation_keys):
        operation = super().get_operation(operation_keys)
        operation.summary = operation.operation_id
        return operation


def get_swagger_view(version='v1'):
    from .urls import api_v1, api_v2
    from django.urls import path, include
    api_v1_patterns = [
        path('api/v1/', include(api_v1))
    ]

    api_v2_patterns = [
        path('api/v2/', include(api_v2))
    ]

    if version == "v2":
        patterns = api_v2_patterns
    else:
        patterns = api_v1_patterns
    schema_view = get_schema_view(
        openapi.Info(
            title="Jumpserver API Docs",
            default_version=version,
            description="Jumpserver Restful api docs",
            terms_of_service="https://www.jumpserver.org",
            contact=openapi.Contact(email="support@fit2cloud.com"),
            license=openapi.License(name="GPLv2 License"),
        ),
        public=True,
        patterns=patterns,
        permission_classes=(permissions.AllowAny,),
    )
    return schema_view

