# ~*~ coding: utf-8 ~*~

from django.forms import ModelForm
from django import forms

from .models import User, UserGroup, Role


class UserAddForm(ModelForm):
    class Meta:
        model = User
        fields = [
            'username', 'name', 'email', 'groups', 'wechat',
            'phone', 'enable_2FA', 'role', 'date_expired', 'comment',
        ]

        help_texts = {
            'username': '* required',
            'name': '* required',
            'email': '* required',
            'groups': '* required'
        }

        widgets = {
            'groups': forms.SelectMultiple(attrs={'class': 'chosen-select', 'data-placeholder': '请选择用户组'})
        }


class UserUpdateForm(ModelForm):
    class Meta:
        model = User
        fields = [
            'name', 'email', 'groups', 'wechat', 'avatar',
            'phone', 'enable_2FA', 'role', 'date_expired', 'comment',
        ]

        help_texts = {
            'username': '* required',
            'name': '* required',
            'email': '* required',
            'groups': '* required'
        }


class UserGroupForm(ModelForm):
    class Meta:
        model = UserGroup
        fields = [
            'name', 'comment',
        ]
        help_texts = {
            'name': '* required'
        }
