# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-06-06 07:05
from __future__ import unicode_literals

import common.utils
from django.db import migrations, models


def remove_deleted_group(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    group_model = apps.get_model("users", "UserGroup")
    group_model.objects.using(db_alias).filter(is_discard=True).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0009_auto_20180517_1537'),
    ]

    operations = [
        migrations.RunPython(
            remove_deleted_group
        ),
        migrations.RemoveField(
            model_name='usergroup',
            name='discard_time',
        ),
        migrations.RemoveField(
            model_name='usergroup',
            name='is_discard',
        ),
        migrations.AlterField(
            model_name='user',
            name='date_expired',
            field=models.DateTimeField(blank=True, db_index=True, default=common.utils.date_expired_default, null=True, verbose_name='Date expired'),
        ),
    ]
