# Generated by Django 2.1.7 on 2019-02-28 10:20

import common.utils.django
from django.db import migrations, models


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# users.migrations.0010_auto_20180606_1505

def remove_deleted_group(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    group_model = apps.get_model("users", "UserGroup")
    group_model.objects.using(db_alias).filter(is_discard=True).delete()


class Migration(migrations.Migration):

    replaces = [('users', '0010_auto_20180606_1505'), ('users', '0011_user_source'), ('users', '0012_auto_20180710_1641'), ('users', '0013_auto_20180807_1116'), ('users', '0014_auto_20180816_1652'), ('users', '0015_auto_20181105_1112'), ('users', '0016_auto_20181109_1505'), ('users', '0017_auto_20181123_1113'), ('users', '0018_auto_20190107_1912')]

    dependencies = [
        ('users', '0009_auto_20180517_1537'),
    ]

    operations = [
        migrations.RunPython(
            code=remove_deleted_group,
        ),
        migrations.RemoveField(
            model_name='usergroup',
            name='discard_time',
        ),
        migrations.RemoveField(
            model_name='usergroup',
            name='is_discard',
        ),
        migrations.AlterField(
            model_name='user',
            name='date_expired',
            field=models.DateTimeField(blank=True, db_index=True, default=common.utils.django.date_expired_default, null=True, verbose_name='Date expired'),
        ),
        migrations.AddField(
            model_name='user',
            name='source',
            field=models.CharField(choices=[('local', 'Local'), ('ldap', 'LDAP/AD'), ('openid', 'OpenID'), ('radius', 'Radius')], default='local', max_length=30, verbose_name='Source'),
        ),
        migrations.AddField(
            model_name='usergroup',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AlterField(
            model_name='user',
            name='last_name',
            field=models.CharField(blank=True, max_length=150, verbose_name='last name'),
        ),
        migrations.AlterField(
            model_name='usergroup',
            name='name',
            field=models.CharField(max_length=128, verbose_name='Name'),
        ),
        migrations.AlterUniqueTogether(
            name='usergroup',
            unique_together={('org_id', 'name')},
        ),
        migrations.AlterField(
            model_name='usergroup',
            name='org_id',
            field=models.CharField(blank=True, db_index=True, default='', max_length=36, verbose_name='Organization'),
        ),
        migrations.AddField(
            model_name='user',
            name='date_password_last_updated',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date password last updated'),
        ),
    ]
