# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-08-20 16:21
from __future__ import unicode_literals

import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import users.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('username', models.CharField(max_length=20, unique=True, verbose_name='\u7528\u6237\u540d')),
                ('name', models.CharField(help_text='* required', max_length=20, verbose_name='\u59d3\u540d')),
                ('email', models.EmailField(help_text='* required', max_length=30, unique=True, verbose_name='\u90ae\u4ef6')),
                ('avatar', models.ImageField(upload_to='avatar', verbose_name='\u5934\u50cf')),
                ('wechat', models.CharField(blank=True, max_length=30, verbose_name='\u5fae\u4fe1')),
                ('phone', models.CharField(blank=True, max_length=20, verbose_name='\u624b\u673a\u53f7')),
                ('enable_otp', models.BooleanField(default=False, verbose_name='\u542f\u7528\u4e8c\u6b21\u9a8c\u8bc1')),
                ('secret_key_otp', models.CharField(blank=True, max_length=16)),
                ('private_key', models.CharField(blank=True, max_length=5000, verbose_name='ssh\u79c1\u94a5')),
                ('public_key', models.CharField(blank=True, max_length=1000, verbose_name='\u516c\u94a5')),
                ('comment', models.TextField(blank=True, max_length=200, verbose_name='\u63cf\u8ff0')),
                ('date_expired', models.DateTimeField(default=users.models.date_expired_default, verbose_name='\u6709\u6548\u671f')),
                ('created_by', models.CharField(default='', max_length=30)),
            ],
            options={
                'db_table': 'user',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80, unique=True, verbose_name='name')),
                ('comment', models.CharField(blank=True, max_length=80)),
                ('permissions', models.ManyToManyField(blank=True, to='auth.Permission', verbose_name='permissions')),
            ],
            options={
                'db_table': 'role',
            },
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='\u7ec4\u540d\u79f0')),
                ('comment', models.TextField(blank=True, verbose_name='\u63cf\u8ff0')),
                ('date_added', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.CharField(max_length=100)),
            ],
            options={
                'db_table': 'usergroup',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(help_text='* required', to='users.UserGroup', verbose_name='\u7528\u6237\u7ec4'),
        ),
        migrations.AddField(
            model_name='user',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='users.Role', verbose_name='\u89d2\u8272'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
    ]
