# Generated by Django 2.1.7 on 2019-07-26 09:53

from django.db import migrations, models


def migrate_loginlog_reason_to_str(apps, schema_editor):
    db_alias = schema_editor.connection.alias

    reason_map = {
        "0": "",
        "1": 'Username/password check failed',
        "2": 'MFA authentication failed',
        "3": "Username does not exist",
        "4": "Password expired",
    }

    model = apps.get_model("audits", "UserLoginLog")
    for k, v in reason_map.items():
        model.objects.using(db_alias).filter(reason=k).update(reason=v)


class Migration(migrations.Migration):

    dependencies = [
        ('audits', '0005_auto_20190228_1715'),
    ]

    operations = [
        migrations.AlterField(
            model_name='userloginlog',
            name='reason',
            field=models.CharField(blank=True, default='', max_length=128, verbose_name='Reason'),
        ),
        migrations.RunPython(migrate_loginlog_reason_to_str),
    ]
