# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-07-02 06:15
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


def migrate_win_to_ssh_protocol(apps, schema_editor):
    asset_model = apps.get_model("assets", "Asset")
    db_alias = schema_editor.connection.alias
    asset_model.objects.using(db_alias).filter(platform__startswith='Win').update(protocol='rdp')


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0016_auto_20180511_1203'),
    ]

    operations = [
        migrations.AddField(
            model_name='asset',
            name='protocol',
            field=models.CharField(choices=[('ssh', 'ssh'), ('rdp', 'rdp'), ('telnet', 'telnet (beta)')], default='ssh', max_length=128, verbose_name='Protocol'),
        ),
        migrations.AddField(
            model_name='systemuser',
            name='login_mode',
            field=models.CharField(choices=[('auto', 'Automatic login'), ('manual', 'Manually login')], default='auto', max_length=10, verbose_name='Login mode'),
        ),
        migrations.AlterField(
            model_name='adminuser',
            name='username',
            field=models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='asset',
            name='platform',
            field=models.CharField(choices=[('Linux', 'Linux'), ('Unix', 'Unix'), ('MacOS', 'MacOS'), ('BSD', 'BSD'), ('Windows', 'Windows'), ('Windows2016', 'Windows(2016)'), ('Other', 'Other')], default='Linux', max_length=128, verbose_name='Platform'),
        ),
        migrations.AlterField(
            model_name='gateway',
            name='username',
            field=models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='protocol',
            field=models.CharField(choices=[('ssh', 'ssh'), ('rdp', 'rdp'), ('telnet', 'telnet (beta)')], default='ssh', max_length=16, verbose_name='Protocol'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='username',
            field=models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.RunPython(migrate_win_to_ssh_protocol),
    ]
