# Generated by Django 2.1.7 on 2019-02-28 10:16

import assets.models.utils
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# assets.migrations.0017_auto_20180702_1415

def migrate_win_to_ssh_protocol(apps, schema_editor):
    asset_model = apps.get_model("assets", "Asset")
    db_alias = schema_editor.connection.alias
    asset_model.objects.using(db_alias).filter(platform__startswith='Win').update(protocol='rdp')


class Migration(migrations.Migration):

    replaces = [('assets', '0010_auto_20180307_1749'), ('assets', '0011_auto_20180326_0957'), ('assets', '0012_auto_20180404_1302'), ('assets', '0013_auto_20180411_1135'), ('assets', '0014_auto_20180427_1245'), ('assets', '0015_auto_20180510_1235'), ('assets', '0016_auto_20180511_1203'), ('assets', '0017_auto_20180702_1415'), ('assets', '0018_auto_20180807_1116'), ('assets', '0019_auto_20180816_1320')]

    dependencies = [
        ('assets', '0009_auto_20180307_1212'),
    ]

    operations = [
        migrations.AlterField(
            model_name='node',
            name='value',
            field=models.CharField(max_length=128, unique=True, verbose_name='Value'),
        ),
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('comment', models.TextField(blank=True, verbose_name='Comment')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date created')),
            ],
        ),
        migrations.CreateModel(
            name='Gateway',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('username', models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username')),
                ('_password', models.CharField(blank=True, max_length=256, null=True, verbose_name='Password')),
                ('_private_key', models.TextField(blank=True, max_length=4096, null=True, validators=[assets.models.utils.private_key_validator], verbose_name='SSH private key')),
                ('_public_key', models.TextField(blank=True, max_length=4096, verbose_name='SSH public key')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_updated', models.DateTimeField(auto_now=True)),
                ('created_by', models.CharField(max_length=128, null=True, verbose_name='Created by')),
                ('ip', models.GenericIPAddressField(db_index=True, verbose_name='IP')),
                ('port', models.IntegerField(default=22, verbose_name='Port')),
                ('protocol', models.CharField(choices=[('ssh', 'ssh'), ('rdp', 'rdp')], default='ssh', max_length=16, verbose_name='Protocol')),
                ('comment', models.CharField(blank=True, max_length=128, null=True, verbose_name='Comment')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('domain', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assets.Domain', verbose_name='Domain')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='asset',
            name='domain',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assets', to='assets.Domain', verbose_name='Domain'),
        ),
        migrations.AddField(
            model_name='systemuser',
            name='assets',
            field=models.ManyToManyField(blank=True, to='assets.Asset', verbose_name='Assets'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='sudo',
            field=models.TextField(default='/bin/whoami', verbose_name='Sudo'),
        ),
        migrations.AlterField(
            model_name='adminuser',
            name='username',
            field=models.CharField(max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_-]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='username',
            field=models.CharField(max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_-]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='adminuser',
            name='username',
            field=models.CharField(max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='username',
            field=models.CharField(max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='node',
            name='value',
            field=models.CharField(max_length=128, verbose_name='Value'),
        ),
        migrations.AddField(
            model_name='asset',
            name='protocol',
            field=models.CharField(choices=[('ssh', 'ssh'), ('rdp', 'rdp'), ('telnet', 'telnet (beta)')], default='ssh', max_length=128, verbose_name='Protocol'),
        ),
        migrations.AddField(
            model_name='systemuser',
            name='login_mode',
            field=models.CharField(choices=[('auto', 'Automatic login'), ('manual', 'Manually login')], default='auto', max_length=10, verbose_name='Login mode'),
        ),
        migrations.AlterField(
            model_name='adminuser',
            name='username',
            field=models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.AlterField(
            model_name='asset',
            name='platform',
            field=models.CharField(choices=[('Linux', 'Linux'), ('Unix', 'Unix'), ('MacOS', 'MacOS'), ('BSD', 'BSD'), ('Windows', 'Windows'), ('Windows2016', 'Windows(2016)'), ('Other', 'Other')], default='Linux', max_length=128, verbose_name='Platform'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='protocol',
            field=models.CharField(choices=[('ssh', 'ssh'), ('rdp', 'rdp'), ('telnet', 'telnet (beta)')], default='ssh', max_length=16, verbose_name='Protocol'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='username',
            field=models.CharField(blank=True, max_length=32, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_@\\-\\.]*$', 'Special char not allowed')], verbose_name='Username'),
        ),
        migrations.RunPython(
            code=migrate_win_to_ssh_protocol,
        ),
        migrations.AddField(
            model_name='adminuser',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='asset',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='domain',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='gateway',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='label',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='node',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AddField(
            model_name='systemuser',
            name='org_id',
            field=models.CharField(blank=True, default=None, max_length=36, null=True),
        ),
        migrations.AlterField(
            model_name='adminuser',
            name='name',
            field=models.CharField(max_length=128, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='asset',
            name='hostname',
            field=models.CharField(max_length=128, verbose_name='Hostname'),
        ),
        migrations.AlterField(
            model_name='gateway',
            name='name',
            field=models.CharField(max_length=128, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='systemuser',
            name='name',
            field=models.CharField(max_length=128, verbose_name='Name'),
        ),
        migrations.AlterUniqueTogether(
            name='adminuser',
            unique_together={('name', 'org_id')},
        ),
        migrations.AddField(
            model_name='asset',
            name='cpu_vcpus',
            field=models.IntegerField(null=True, verbose_name='CPU vcpus'),
        ),
        migrations.AlterUniqueTogether(
            name='asset',
            unique_together={('org_id', 'hostname')},
        ),
        migrations.AlterUniqueTogether(
            name='gateway',
            unique_together={('name', 'org_id')},
        ),
        migrations.AlterUniqueTogether(
            name='systemuser',
            unique_together={('name', 'org_id')},
        ),
        migrations.AlterUniqueTogether(
            name='label',
            unique_together={('name', 'value', 'org_id')},
        ),
    ]
