# coding: utf-8
# __author__ = 'zdx'
# __date__ = '2017-12-18 15:04'

from django.views import View
import json
import base64
from Crypto.Cipher import PKCS1_v1_5
from Crypto.Cipher import AES
from Crypto.PublicKey import RSA
from collections import OrderedDict
from Crypto.Hash import SHA
from Crypto.Signature import PKCS1_v1_5 as SIGN_PKCS
from django.conf import settings
from django.http import JsonResponse
import uuid
from models.offline import OLInstallment



BS = AES.block_size
PLA_PUB = RSA.importKey(settings.BJD_PLATFORM_PUBKEY)
PLA_PRI = RSA.importKey(settings.BJD_PLATFORM_PRIKEY)
MER_PUB = RSA.importKey(settings.BJD_MERCHANT_PUBKEY)
MER_PRI = RSA.importKey(settings.BJD_MERCHANT_PRIKEY)


def chunks(l, n):
    for i in range(0, len(l), n):
        yield l[i:i + n]


class BJDBaseView(View):

    def dispatch(self, request, *args, **kwargs):
        print(request.POST)
        # request.realDate = self.decrypt(request.POST)
        request.realData = request.POST
        data = super().dispatch(request, *args, **kwargs)
        request_id = uuid.uuid4().hex
        # data = self._encrypt(data, request_id)
        return JsonResponse(data)

    def decrypt(self, data,):
        content = base64.b64decode(data['data'])
        encryptkey = base64.b64decode(data['encryptkey'])
        decrypt = PKCS1_v1_5.new(PLA_PRI).decrypt
        aes_key = b''.join(decrypt(x, object()) for x in chunks(encryptkey, 128))
        unpad = lambda s: s[0:-ord(s[-1])]
        real_data = unpad(AES.new(aes_key).decrypt(content).decode('utf-8'))
        real_data = json.loads(real_data, object_pairs_hook=OrderedDict)
        raw_sign = base64.b64decode(real_data.pop('sign'))
        unsign = self._sortdata(real_data)
        assert SIGN_PKCS.new(MER_PRI).verify(SHA.new(unsign.encode('utf-8')), raw_sign)
        return dict(real_data)

    def _encrypt(self, params, key):
        params = {x: str(params[x]) for x in params}
        key = key[:16]
        params['sign'] = self._singer(params)
        json_params = json.dumps(params).encode('utf-8')
        pkcs5_pad = lambda s: s + (BS - len(s) % BS) * (chr(BS - len(s) % BS).encode())
        content = AES.new(key).encrypt(pkcs5_pad(json_params))
        cipher = PKCS1_v1_5.new(PLA_PUB)
        encryptkey = b''.join([cipher.encrypt(x) for x in chunks(key.encode('utf-8'), 117)])
        return {
            'data': base64.b64encode(content),
            'encryptkey': base64.b64encode(encryptkey)
        }

    def _sortdata(self, data):
        result = ''
        for k in sorted(data.keys()):
            if isinstance(data[k], str):
                result += data[k]
            else:
                result += json.dumps(data[k], separators=(',', ':'), ensure_ascii=False)
        return result

    def _singer(self, data):
        signstr = ''.join([data[k] for k in sorted(data.keys())])
        sign = SIGN_PKCS.new(MER_PRI).sign(SHA.new(signstr.encode('utf-8')))
        return base64.b64encode(sign).decode()
