# coding: utf-8
# __author__ = 'zdx'
# __date__ = '2017-12-18 14:34'

from django.views import View
from django.http import JsonResponse
from bjd.base import *
from models.offline import OLInstallment
from datetime import datetime, timedelta


class Apply(BJDBaseView):
    def post(self, request):
        order_no = int(request.realData.get('orderno'))
        installment = OLInstallment.objects.get(id=order_no)

        data = {
            'merchantno': settings.BJD_MERCHANT_NO,
            'orderno': installment.id,
            'status': 'ORDER_SUCCESS',
            'msg': ''
        }
        print(data)
        return data


class Confirm(BJDBaseView):
    def post(self,request):
        order_no = int(request.realData.get('orderno'))
        installment = OLInstallment.objects.get(id=order_no)

        return {
            'merchantno': settings.BJD_MERCHANT_NO,
            'orderno': installment.id,
            'startdate': datetime.now().strftime('%Y-%m-%d'),
            'enddate': (datetime.now() + timedelta(days=30*installment.period)).strftime('%Y-%m-%d'),
            'projectmoney': int(installment.amount * 0.8),
            'interestmode': 'DBDX',
            'periods': installment.period,
            'firstrepayment': '%.2f' % (installment.amount * 0.8 / installment.period),
            'repaymentdate': (datetime.now() + timedelta(days=30)).strftime('%Y-%m-%d'),
            'contracturl': '',
            'status': '0000',
            'msg': '',
        }


class Detail(BJDBaseView):
    def post(self,request):
        order_no = int(request.realData.get('orderno'))
        installment = OLInstallment.objects.get(id=order_no)
        return {
            'merchantno': settings.BJD_MERCHANT_NO,
            'orderno': installment.id,
            'projectname': installment.item_name,
            'startdate': installment.confirm_time.strftime('%Y-%m-%d'),
            'enddate': (installment.confirm_time + timedelta(days=30 * installment.period)).strftime('%Y-%m-%d'),
            'projectmoney': installment.allow_amount,
            'costmoney': '%.2f' % (installment.allow_amount * 12 * 0.0108),
            'interestmode': 'DBDX',
            'periods': installment.period,
            'firstrepayment': '%.2f' % (installment.allow_amount / installment.period),
            'repaymentdate': (installment.confirm_time + timedelta(days=30)).strftime('%Y-%m-%d'),
            'projecStatus': '1',
            'repayRecords': [
                {
                    'period': i + 1,
                    'principalRepayment': '%.2f' % (installment.allow_amount / installment.period),
                    'serviceMoney': '%.2f' % (installment.allow_amount * 0.0108),
                    'penalty': '0.00',
                    'allMoney': '%.2f' % (
                        installment.allow_amount / installment.period + installment.allow_amount * 0.0108),
                    'afterMoney': '0.00',
                    'intentDate': (installment.confirm_time + timedelta(days=30 * (i + 1))).strftime('%Y%m%d'),
                    'factDate': '',
                    'status': '1',
                } for i in range(installment.period)
                ],
            'status': '0000',
            'msg': '',
        }


class Certificate(BJDBaseView):
    def post(self,request):
        userid = request.realData.get('userid')
        telephone = request.realData.get('telephone')
        return {
            'merchantno': settings.BJD_MERCHANT_NO,
            'userid': userid,
            'telephone': telephone,
            'cerRecords': [
                {
                    'autResult': '1',
                    'autType': '1001',
                },
                {
                    'autResult': '1',
                    'autType': '1002',
                },
                {
                    'autResult': '1',
                    'autType': '1004',
                },
                {
                    'autResult': '1',
                    'autType': '1005',
                },

            ],
            'status': '0000',
            'msg': ''
        }


class Result(BJDBaseView):
    def post(self, request):
        order_no = int(request.realData.get('orderno'))
        installment = OLInstallment.objects.get(id=order_no)
        return {
            'merchantno': settings.BJD_MERCHANT_NO,
            'orderno': installment.id,
            'startdate': datetime.now().strftime('%Y-%m-%d'),
            'enddate': (datetime.now() + timedelta(days=30 * installment.period)).strftime('%Y-%m-%d'),
            'projectmoney': int(installment.amount * 0.8),
            'interestmode': 'DBDX',
            'periods': installment.period,
            'remarks': '',
            'firstrepayment': '%.2f' % (installment.amount * 0.8 / installment.period),
            'firstservice': '%.2f' % (installment.amount * 0.8 * 0.0108),
            'repaymentdate': (datetime.now() + timedelta(days=30)).strftime('%Y-%m-%d'),
            'contracturl': '',
            'status': '0000',
            'payresoult': '2222',
            'backcode': '',
            'msg': '',
        }


class Submit(BJDBaseView):
    def post(self, request):
        order_no = int(request.realData.get('orderno'))
        return {
            'merchantno': settings.BJD_MERCHANT_NO,
            'orderno': order_no,
            'status': '0000',
            'msg': ''
        }

