# coding: utf-8
# __author__ = 'zdx'
# __date__ = '2017-12-15 17:25'

from django.db import models
from django.db.models import FloatField
from django.db.models import CharField, IntegerField, DateTimeField
from gm_crypto.fields import EncryptedCharField
from gm_types.plutus.offline import ORDER


class OLInstallment(models.Model):
    class Meta:
        verbose_name = '分期单'
        db_table = 'offline_installment'
        app_label = 'installment'

    borrower_id = IntegerField('借款人')
    bank_id = IntegerField()
    service = CharField('服务商', max_length=32, default=None)
    item_name = CharField('项目名称', max_length=32, default='')
    hospital_id = IntegerField()
    amount = IntegerField('申请金额')
    allow_amount = IntegerField('审批金额', default=None)
    period = IntegerField('期数', default=0)
    status = CharField('分期单状态', default=ORDER.PRE, max_length=16)
    backmessage = CharField('审批结果说明', max_length=250, default=None)
    reapply_id = IntegerField('继续申请分期单ID', default=None, null=True)

    audit_time = DateTimeField('提交审核时间', default=None)
    callback_time = DateTimeField('第三方审核回调时间', default=None)
    confirm_time = DateTimeField('用户确认时间', default=None)
    first_repaytime = DateTimeField('首次还款时间', default=None)
    first_interest = FloatField('首次还款利息', default=0.0)
    create_time = DateTimeField(auto_now_add=True)

    snapshot = models.TextField(default=None, verbose_name='订单快照')
    name = EncryptedCharField('下单时真实姓名', max_length=24, default=None)
    phone = EncryptedCharField("下单时电话", max_length=20, unique=True, default=None)
    id_card = EncryptedCharField('下单时身份证号', max_length=24, default=None)


