import unittest, os
from gm_rpcd.internals.protocol.request import make_request_from_v1
from gm_rpcd.internals.initializations import initialize
from gm_rpcd.internals.protocol.response import SuccessResponse
from django.test import TestCase

class DorisTestCase(TestCase):

    def setUp(self):
        os.environ["GM_RPCD_MODE"] = "develop"

    def call(self, method, params = {}, session_key = None):
        dispatcher = initialize().dispatcher
        request = make_request_from_v1(
            method=method,
            params=params,
            session_key=session_key,
            environment=None,
        )
        response = dispatcher.process_single_request(request)
        if type(response) == SuccessResponse:
            response.code = 0
        return response
