# coding=utf-8
from libs.rpc import get_rpc_invoker


def search_tags_by_name(query, tag_types=None):
    rpc_invoker = get_rpc_invoker()
    tags = rpc_invoker['api/tag/hera_search'](query=query, tag_type_in=tag_types).unwrap()
    return tags


def get_services_by_ids(ids):
    rpc_invoker = get_rpc_invoker()
    services = rpc_invoker['api/service/by_ids'](ids=ids).unwrap()
    return services


def get_doctors_by_ids(ids):
    rpc_invoker = get_rpc_invoker()
    doctors = rpc_invoker['api/doctor/multi_detail'](id_list=ids).unwrap()
    return doctors['doctor_info']


def search_doctors_by_id_prefix(id_prefix, doctor_type=None):
    rpc_invoker = get_rpc_invoker()
    doctors = rpc_invoker['api/doctor/hera_search'](
        id_query=id_prefix, doctor_type=doctor_type,
        offset=0, size=5).unwrap()
    return doctors


def get_tags_by_ids(ids):
    rpc_invoker = get_rpc_invoker()
    tags = rpc_invoker['api/tag/info_by_ids'](tag_ids=ids).unwrap()
    return tags


def get_diary_by_ids(ids):
    rpc_invoker = get_rpc_invoker()
    diaries = rpc_invoker['talos/diary/get_diary_info_by_ids'](ids=ids).unwrap()
    return diaries