from django.contrib import admin
from word.models import Word, StopWord
from word.tasks import generate_word, generate_stopword
# Register your models here.

class WordAdmin(admin.ModelAdmin):
    actions=['generate_word_action',]

    def generate_word_action(self, request, queryset):
        print('run generate_word_action')
        generate_word.delay()

    generate_word_action.short_description='生成词库'


class StopWordAdmin(admin.ModelAdmin):
    actions = ['generate_word_action',]

    def generate_word_action(self, request, queryset):
        generate_stopword.delay()

    generate_word_action.short_description = '生成停止词库'

admin.site.register(Word, WordAdmin)
admin.site.register(StopWord, StopWordAdmin)

