from django.db import models

from gm_types.gaia import DIARY_CONTENT_LEVEL


class Diary(models.Model):
    """
        日记本
    """

    class Meta:
        verbose_name = u'日记本'
        verbose_name_plural = u'日记本'
        app_label = 'talos'
        db_table = 'api_diary'

    user_id = models.IntegerField()
    content_level = models.CharField(verbose_name=u'内容等级', max_length=1,
                                     choices=DIARY_CONTENT_LEVEL,
                                     default=DIARY_CONTENT_LEVEL.UNAUDITED)
