import json
from datetime import datetime
from datetime import timedelta
from datetime import date
from celery import shared_task

from django.db.models import Sum
from recommend.models import ServiceHot, DeviceInterestSource, ServiceHotSource, DeviceInterest
from recommend.models import DeviceInterestService, DeviceInterestServiceSource
from libs.cache import redis_client

@shared_task
def cal_userinterest_rank():
    today = datetime.today()
    start_day = today - timedelta(days=7)

    deviceinterests = DeviceInterestSource.objects.filter(updated_at__gte=start_day, updated_at__lt=today).values(
        "device_id", "tag_id").annotate(
        Sum("view_service_count"), Sum("favor_service_count"), Sum("view_diary_count"), Sum("view_wiki_count"))

    for deviceinterest in deviceinterests:
        print(deviceinterest)
        device_id = deviceinterest.get("device_id")
        tag_id = deviceinterest.get("tag_id")
        item, created = DeviceInterest.objects.get_or_create(device_id=device_id, tag_id=tag_id)
        view_service_count = deviceinterest.get("view_service_count__sum")
        favor_service_count = deviceinterest.get("favor_service_count__sum")
        view_diary_count = deviceinterest.get("view_diary_count__sum")
        view_wiki_count = deviceinterest.get("view_wiki_count__sum")
        item.cal_rank(view_service_count, favor_service_count, view_diary_count, view_wiki_count)
        item.updated_at = date.today()
        item.save()


@shared_task
def cal_servicehot_rank():
    today = datetime.today()
    start_day = today - timedelta(days=7)
    servicehots = ServiceHotSource.objects.filter(updated_at__gte=start_day, updated_at__lt=today).values("service_id",
                                                                                                          "tag_id").annotate(
        Sum("order_validate_count"), Sum("view_service_count"), Sum("ask_service_count")
    )
    for servicehot in servicehots:
        print(servicehot)
        service_id = servicehot.get("service_id")
        tag_id = servicehot.get("tag_id")
        item, created = ServiceHot.objects.get_or_create(service_id=service_id, tag_id=tag_id)
        order_validate_count = servicehot.get("order_validate_count__sum")
        view_service_count = servicehot.get("view_service_count__sum")
        ask_service_count = servicehot.get("ask_service_count__sum")
        item.cal_rank(order_validate_count, view_service_count, ask_service_count)
        item.updated_at = date.today()
        item.save()

    hotitems = ServiceHot.objects.values("service_id").distinct()
    for hotitem in hotitems:
        print(hotitem)
        service_id = hotitem.get("service_id")
        service_items = ServiceHot.objects.filter(service_id=service_id)
        tag_heat = []
        for service in service_items:
            tag_heat.append({
                "tag_id": service.tag_id,
                "heat_score": service.rank
            })
        print(tag_heat)
        cache_data = {
            "tag_heat": tag_heat
        }
        redis_key = ServiceHot.get_stat_key(service_id)
        redis_client.set(redis_key, json.dumps(cache_data))


@shared_task
def transport_devicesource():
    today = datetime.today()
    day = today - timedelta(days=1)
    items = DeviceInterestServiceSource.objects.filter(updated_at=day)
    for item in items:
        records = DeviceInterestService.objects.filter(device_id=item.device_id,tag_id=item.tag_id)
        count = records.count()
        if count >1:
            for record in records:
                record.delete()
        deviceservice, created = DeviceInterestService.objects.get_or_create(device_id=item.device_id,tag_id=item.tag_id)
        deviceservice.rank = item.rank
        deviceservice.updated_at = item.updated_at
        deviceservice.save()
        


