from django.conf import settings
from gm_rpcd.all import bind
from gm_types.gaia import DIARY_ORDER_TYPE
from libs.es import tzlc, get_es, es_query, es_index_adapt, es_indices_analyze, get_highlight_query_analyzer, es_msearch
from libs.filters import area_tag_id_filter
from libs.error import logging_exception
from search.utils.diary import recall_diary
from collections import OrderedDict
from libs.algorithms import variousness
import logging
import traceback
import json
import copy
from libs.cache import redis_client
from search.utils.diary import get_wordrel_set, wordrel_some_list
from search.utils.answer import recall_comprehensive_ans
from search.utils.article import recall_comprehensive_art
from search.views.tractate import query_filter_comprehensive_tractate
from libs.es import es_index_adapt
from search.views.diary import get_diary_alpha_query, get_diary_posts_results
from libs.cache import redis_client
from search.views.diary import search_diary, search_diary_alpha
from search.utils.diary import get_cpc_diary
from search.utils.service import recommed_service_category_device_id

logger = logging.getLogger(__name__)


def _get_answer_ret_item(ret_list, answer_results_list, answer_index, score_base, get_num, answer_have_read_list,
                         ans_question_read_id_set, size):
    """
    获取问答数据
    :param ret_list:
    :param answer_results_list:
    :param answer_index:
    :return:
    """
    try:
        cur_index = 0
        have_read_over = False
        if len(answer_results_list) <= answer_index:
            return (True, answer_index)

        for answer_item in answer_results_list[answer_index:]:
            if answer_item["_score"] < score_base:
                have_read_over = True
                break
            else:
                if answer_item["_source"]["question_id"] not in ans_question_read_id_set:
                    if cur_index < get_num and len(ret_list) < size:
                        ret_answer_item = {
                            "id": answer_item["_id"],
                            "type": 1,
                            "highlight": answer_item["highlight"] if "highlight" in answer_item else {}
                        }
                        answer_have_read_list.append(answer_item["_id"])
                        ret_list.append(ret_answer_item)
                        ans_question_read_id_set.add(answer_item["_source"]["question_id"])
                        cur_index += 1
                    else:
                        break
                answer_index += 1

        return (have_read_over, answer_index)
    except:
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        logging_exception()
        return (True, answer_index)


def _get_diary_ret_item(ret_list, diary_results_list, diary_index, score_base, get_num, diary_have_read_list, size):
    """
    获取日记数据
    :param ret_list:
    :param diary_results_list:
    :param diary_index:
    :param score_base:
    :param get_num:
    :return:
    """
    try:
        cur_index = 0
        have_read_over = False
        if len(diary_results_list) <= diary_index:
            return (True, diary_index, 0)

        for diary_item in diary_results_list[diary_index:]:
            # if diary_item["_score"]<score_base:
            #     have_read_over = True
            #     break
            # else:
            if cur_index < get_num and len(ret_list) < size:
                ret_diary_item = {
                    "id": diary_item["_id"],
                    "type": 2,
                    "highlight": diary_item["highlight"] if "highlight" in diary_item else {}
                }
                diary_have_read_list.append(diary_item["_id"])
                ret_list.append(ret_diary_item)
                diary_index += 1
                cur_index += 1
            else:
                break

        return (have_read_over, diary_index, cur_index)
    except:
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        logging_exception()
        return (True, diary_index, 0)


def _get_diary_posts_ret_item(ret_list, diary_results_list, diary_posts_index, get_num, diary_have_read_list, size):
    """
    获取日记本下日记帖数据
    :param ret_list:
    :param diary_results_list:
    :param diary_index:
    :param score_base:
    :param get_num:
    :return:
    """
    try:
        cur_index = 0
        have_read_over = False
        if len(diary_results_list) <= diary_posts_index:
            return (True, diary_posts_index, 0)

        for diary_item in diary_results_list[diary_posts_index:]:
            if cur_index < get_num and len(ret_list) < size:
                ret_diary_item = {
                    "id": diary_item["_source"]["diary_id"],
                    "type": 2,
                    "highlight": diary_item["highlight"] if "highlight" in diary_item else {}
                }
                diary_have_read_list.append(diary_item["_source"]["diary_id"])
                ret_list.append(ret_diary_item)
                cur_index += 1
                diary_posts_index += 1
            else:
                break

        return (have_read_over, diary_posts_index, cur_index)
    except:
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        logging_exception()
        return (True, diary_posts_index, 0)


def _get_tractate_ret_list(ret_list, tractate_results_list, tractate_index, score_base, get_num,
                           tractate_have_read_list, size):
    """
    获取帖子数据
    :param ret_list:
    :param tractate_results_list:
    :param tractate_index:
    :param score_base:
    :param get_num:
    :return:
    """
    try:
        cur_index = 0
        have_read_over = False
        if len(tractate_results_list) <= tractate_index:
            return (True, tractate_index)

        for tractate_item in tractate_results_list[tractate_index:]:
            if tractate_item["_score"] < score_base:
                have_read_over = True
                break
            else:
                if cur_index < get_num and len(ret_list) < size:
                    ret_tractate_item = {
                        "id": tractate_item["_id"],
                        "type": 3,
                        "highlight": tractate_item["highlight"] if "highlight" in tractate_item else {}
                    }
                    tractate_have_read_list.append(tractate_item["_id"])
                    ret_list.append(ret_tractate_item)
                    tractate_index += 1
                    cur_index += 1
                else:
                    break

        return (have_read_over, tractate_index)
    except:
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        logging_exception()
        return (True, tractate_index)


def _get_article_ret_list(ret_list, article_results_list, article_index, score_base, get_num, article_have_read_list,
                          size):
    """
    获取专栏数据
    :param ret_list:
    :param article_results_list:
    :param article_index:
    :param score_base:
    :param get_num:
    :return:
    """
    try:
        cur_index = 0
        have_read_over = False
        if len(article_results_list) <= article_index:
            return (True, article_index)

        for article_item in article_results_list[article_index:]:
            if article_item["_score"] < score_base:
                have_read_over = True
                break
            else:
                if cur_index < get_num and len(ret_list) < size:
                    ret_article_item = {
                        "id": article_item["_id"],
                        "type": 4,
                        "highlight": article_item["highlight"] if "highlight" in article_item else {}
                    }
                    article_have_read_list.append(article_item["_id"])
                    ret_list.append(ret_article_item)
                    article_index += 1
                    cur_index += 1
                else:
                    break

        return (have_read_over, article_index)
    except:
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        logging_exception()
        return (True, article_index)


@bind("dymas/search/query_comprehensive")
def query_comprehensive(query='',
                        offset=0,
                        size=10,
                        sort_type=DIARY_ORDER_TYPE.DEFAULT,
                        filters=None,
                        sort_params=None,
                        sort_diary_tag_first=False,
                        device_id="null",
                        use_fresh_tag=False):
    """
    2问答+1日记+1帖子+1日记+1专栏
    :param query:
    :param offset:
    :param size:
    :param device_id:
    :return:
    """
    try:
        need_cpc_diary_num = 3
        batch_query_list = list()
        # 日记、帖子、问答、专栏

        if not filters:
            filters = dict()

        es = get_es()
        body = {
            'text': query,
            'analyzer': "gm_default_index"
        }
        res = es_indices_analyze(doc_type="diary", body=body, es=es)
        wordrel_set, correct_term_list = get_wordrel_set(query)
        (total_query_term_list, complete_matching_term_list, other_key_word_term_list,
         other_key_word_term_str) = wordrel_some_list(res, wordrel_set, query)

        answer_have_read_list = list()
        question_id_have_read_list = list()
        diary_have_read_list = list()
        tractate_have_read_list = list()
        article_have_read_list = list()

        redis_key = "doris:search_comprehensive:have_read_list:" + device_id
        if offset != 0:
            have_read_dict = redis_client.hgetall(redis_key)
            if b"answer" in have_read_dict:
                answer_have_read_list = json.loads(have_read_dict[b"answer"])
            if b"question_id" in have_read_dict:
                question_id_have_read_list = json.loads(have_read_dict[b"question_id"])
            if b"article" in have_read_dict:
                article_have_read_list = json.loads(have_read_dict[b"article"])
            if b"tractate" in have_read_dict:
                tractate_have_read_list = json.loads(have_read_dict[b"tractate"])
            if b"diary" in have_read_dict:
                diary_have_read_list = json.loads(have_read_dict[b"diary"])

        user_city_tag_id = -1
        if sort_params:
            user_city_tag_id = sort_params.get('user_city_tag_id', -1)
        if user_city_tag_id is None:
            user_city_tag_id = -1

        # 获取日记cpc数据
        cpc_diary_list = list()
        if offset == 0:
            cpc_diary_list = get_cpc_diary(query=query, device_id=device_id, city_id=user_city_tag_id,
                                           cpc_diary_num=need_cpc_diary_num)
            diary_have_read_list.extend(cpc_diary_list)

        ###取拓展词
        closure_tags_name_list = redis_client.hget("service_closure_tags", query)
        closure_tags = list()
        if closure_tags_name_list and len(closure_tags_name_list) > 0:
            closure_tags = json.loads(closure_tags_name_list)

        answer_query = recall_comprehensive_ans(query=query, correct_term_list=correct_term_list,
                                                other_key_word_term_list=other_key_word_term_list, offset=offset,
                                                size=size, have_read_id_list=answer_have_read_list,
                                                question_id_have_read_list=question_id_have_read_list,
                                                other_key_word_term_str=other_key_word_term_str,
                                                total_query_term_list=total_query_term_list, closure_tags=closure_tags)
        article_query = recall_comprehensive_art(query=query, correct_term_list=correct_term_list,
                                                 other_key_word_term_list=other_key_word_term_list, offset=offset,
                                                 size=size, have_read_id_list=article_have_read_list,
                                                 closure_tags=closure_tags)
        tractate_query = query_filter_comprehensive_tractate(query=query, correct_term_list=correct_term_list,
                                                             other_key_word_term_list=other_key_word_term_list,
                                                             offset=offset, size=size,
                                                             have_read_id_list=tractate_have_read_list,
                                                             closure_tags=closure_tags)
        # diary_query = get_diary_alpha_query(query=query,offset=offset,size=size,device_id=device_id,total_query_term_list=total_query_term_list,sort_type=sort_type,
        #                                     complete_matching_term_list=complete_matching_term_list,synonym_term_list=synonym_term_list,sort_params=sort_params,filters=filters,
        #                                     other_key_word_term_list=other_key_word_term_list,correct_term_list=correct_term_list,have_read_id_list=diary_have_read_list)

        # diary_query = search_diary(query=query,offset=0,size=size,filters=filters,sort_params=sort_params,device_id=device_id,search_again=True,sort_type=DIARY_ORDER_TYPE.SEARCH_V1,have_read_diary_list=diary_have_read_list,only_get_query=True)
        diary_query = search_diary_alpha(query=query, offset=0, size=size, filters=filters, sort_params=sort_params,
                                         device_id=device_id, search_again=True, sort_type=DIARY_ORDER_TYPE.SEARCH_V1,
                                         have_read_diary_list=diary_have_read_list, only_get_query=True,
                                         closure_tags=closure_tags)

        answer_index_name = es_index_adapt(index_prefix=settings.ES_INDEX_PREFIX, doc_type="answer", rw="read")
        article_index_name = es_index_adapt(index_prefix=settings.ES_INDEX_PREFIX, doc_type="article", rw="read")
        tractate_index_name = es_index_adapt(index_prefix=settings.ES_INDEX_PREFIX, doc_type="tractate", rw="read")
        diary_index_name = es_index_adapt(index_prefix=settings.ES_INDEX_PREFIX, doc_type="diary", rw="read")

        query_body = ""
        answer_header_dict = {'index': answer_index_name, 'type': "answer"}
        query_body += "{}\n{}\n".format(json.dumps(answer_header_dict), json.dumps(answer_query))

        article_header_dict = {'index': article_index_name, 'type': "article"}
        query_body += "{}\n{}\n".format(json.dumps(article_header_dict), json.dumps(article_query))

        tractate_header_dict = {'index': tractate_index_name, 'type': "tractate"}
        query_body += "{}\n{}\n".format(json.dumps(tractate_header_dict), json.dumps(tractate_query))

        diary_header_dict = {'index': diary_index_name, 'type': "diary"}
        query_body += "{}\n{}\n".format(json.dumps(diary_header_dict), json.dumps(diary_query))

        res = es_msearch(query_body)

        # logger.info("duan add,comprehensive res[diary]:%s" % str(diary_query).encode("utf-8"))
        # logger.info("duan add,comprehensive res:%s" % str(res).encode("utf-8"))

        diary_index = 0
        diary_posts_index = 0

        answer_index = 0
        article_index = 0
        tractate_index = 0

        diary_results_list = list()
        answer_results_list = list()
        article_results_list = list()
        tractate_results_list = list()
        if len(res) > 0 and "responses" in res:
            for item in res["responses"]:
                if "hits" in item and "hits" in item["hits"] and len(item["hits"]["hits"]) > 0:
                    if item["hits"]["hits"][0]["_type"] == "answer":
                        answer_results_list = item["hits"]["hits"]
                    elif item["hits"]["hits"][0]["_type"] == "article":
                        article_results_list = item["hits"]["hits"]
                    elif item["hits"]["hits"][0]["_type"] == "tractate":
                        tractate_results_list = item["hits"]["hits"]
                    elif item["hits"]["hits"][0]["_type"] == "diary":
                        diary_results_list = item["hits"]["hits"]

        diary_posts_query = False
        diary_posts_list = list()
        # 如果日记本数不足，查找日记帖内容
        # if len(diary_results_list)<size:
        #     diary_have_read_list_posts = copy.deepcopy(diary_have_read_list)
        #     diary_have_read_list_posts.extend(diary_results_list)
        #     diary_posts_list = get_diary_posts_results(correct_term_list=correct_term_list,
        #                                                have_read_id_list=diary_have_read_list_posts,offset=offset,size=size)
        #     diary_results_list.extend(diary_posts_list)

        ans_question_read_id_set = set()
        ret_list = list()

        total_match_answer_read_over = False
        total_match_diary_read_over = False
        total_match_tractate_read_over = False
        total_match_article_read_over = False

        other_key_answer_read_over = False
        other_key_diary_read_over = False
        other_key_article_read_over = False
        other_key_tractate_read_over = False

        """
        2019-10-21
        2问答+1日记+1帖子+1日记+1专栏（非灰）

        1个日记、2个帖子、2个问答、1个专栏（灰度）
        灰度哈希后尾号为0-4 a,b,c,e
        """
        # has_bool = recommed_service_category_device_id(device_id)

        has_bool = True
        if has_bool == False:

            while len(ret_list) < size:
                # 全命中逻辑
                total_match_answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list,
                                                                                  answer_index, 1000, 2,
                                                                                  answer_have_read_list,
                                                                                  ans_question_read_id_set, size)

                total_match_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                   diary_results_list,
                                                                                                   diary_index, 1000, 1,
                                                                                                   diary_have_read_list,
                                                                                                   size)

                # if have_get_diary_num<3:
                #     if not diary_posts_query:
                #         diary_posts_list = get_diary_posts_results(correct_term_list=correct_term_list,
                #                                                    have_read_id_list=diary_have_read_list, offset=offset,
                #                                                    size=size)
                #         diary_posts_query=True
                #
                #     total_match_diary_read_over, diary_posts_index, have_get_diary_num = _get_diary_posts_ret_item(ret_list,diary_posts_list,diary_posts_index,2,diary_have_read_list,size)

                total_match_tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list,
                                                                                        tractate_index,
                                                                                        1000, 1,
                                                                                        tractate_have_read_list, size)
                total_match_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                   diary_results_list,
                                                                                                   diary_index, 1000, 1,
                                                                                                   diary_have_read_list,
                                                                                                   size)
                total_match_article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list,
                                                                                     article_index, 1000,
                                                                                     1, article_have_read_list, size)

                # 核心词逻辑
                if total_match_answer_read_over:
                    other_key_answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list,
                                                                                    answer_index, 500, 2,
                                                                                    answer_have_read_list,
                                                                                    ans_question_read_id_set, size)

                if total_match_diary_read_over:
                    other_key_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                     diary_results_list,
                                                                                                     diary_index, 200,
                                                                                                     1,
                                                                                                     diary_have_read_list,
                                                                                                     size)
                if total_match_tractate_read_over:
                    other_key_tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list,
                                                                                          tractate_results_list,
                                                                                          tractate_index,
                                                                                          500, 1,
                                                                                          tractate_have_read_list, size)
                if total_match_diary_read_over:
                    other_key_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                     diary_results_list,
                                                                                                     diary_index, 200,
                                                                                                     1,
                                                                                                     diary_have_read_list,
                                                                                                     size)

                if total_match_article_read_over:
                    other_key_article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list,
                                                                                       article_index, 500,
                                                                                       1, article_have_read_list, size)
                if total_match_answer_read_over and total_match_diary_read_over and total_match_article_read_over and total_match_tractate_read_over and \
                        other_key_answer_read_over and other_key_diary_read_over and other_key_article_read_over and other_key_tractate_read_over:
                    break

            # other_key_answer_read_over = False
            # other_key_diary_read_over = False
            # other_key_article_read_over = False
            # # 其次确保取完核心词命中的
            # while len(ret_list) < size:
            #     other_key_answer_read_over,answer_index = _get_answer_ret_item(ret_list, answer_results_list, answer_index, 500, 2,
            #                                                         answer_have_read_list, ans_question_read_id_set, size)
            #     other_key_diary_read_over,diary_index,have_get_diary_num = _get_diary_ret_item(ret_list, diary_results_list, diary_index, 200, 3,
            #                                                       diary_have_read_list, size)
            #     # other_key_tractate_read_over,tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list, tractate_index,
            #     #                                                         500, 1, tractate_have_read_list, size)
            #     # other_key_diary_read_over,diary_index = _get_diary_ret_item(ret_list, diary_results_list, diary_index, 200, 1,
            #     #                                                   diary_have_read_list, size)
            #     other_key_article_read_over,article_index = _get_article_ret_list(ret_list, article_results_list, article_index, 500,
            #                                                           1, article_have_read_list, size)
            #     if other_key_answer_read_over and other_key_diary_read_over and other_key_article_read_over:
            #         break

            while len(ret_list) < size:
                answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list, answer_index, 0, 2,
                                                                      answer_have_read_list, ans_question_read_id_set,
                                                                      size)
                diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list, diary_results_list,
                                                                                       diary_index, 0, 1,
                                                                                       diary_have_read_list, size)
                tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list,
                                                                            tractate_index, 0, 1,
                                                                            tractate_have_read_list, size)
                diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list, diary_results_list,
                                                                                       diary_index, 0, 1,
                                                                                       diary_have_read_list, size)
                article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list, article_index,
                                                                         0, 1, article_have_read_list, size)

                if answer_read_over and diary_read_over and article_read_over and tractate_read_over:
                    break

        else:
            while len(ret_list) < size:
                # 全命中逻辑 1个日记、2个帖子、2个问答、1个专栏
                total_match_answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list,
                                                                                  answer_index, 1000, 2,
                                                                                  answer_have_read_list,
                                                                                  ans_question_read_id_set, size)

                total_match_tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list,
                                                                                        tractate_index,
                                                                                        1000, 2,
                                                                                        tractate_have_read_list, size)

                total_match_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                   diary_results_list,
                                                                                                   diary_index, 1000, 1,
                                                                                                   diary_have_read_list,
                                                                                                   size)

                total_match_article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list,
                                                                                     article_index, 1000,
                                                                                     1, article_have_read_list, size)

                # 核心词逻辑

                if total_match_answer_read_over:
                    other_key_answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list,
                                                                                    answer_index, 500, 2,
                                                                                    answer_have_read_list,
                                                                                    ans_question_read_id_set, size)
                if total_match_tractate_read_over:
                    other_key_tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list,
                                                                                          tractate_results_list,
                                                                                          tractate_index,
                                                                                          500, 2,
                                                                                          tractate_have_read_list, size)
                if total_match_diary_read_over:
                    other_key_diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list,
                                                                                                     diary_results_list,
                                                                                                     diary_index, 200,
                                                                                                     1,
                                                                                                     diary_have_read_list,
                                                                                                     size)
                if total_match_article_read_over:
                    other_key_article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list,
                                                                                       article_index, 500,
                                                                                       1, article_have_read_list, size)

                if total_match_answer_read_over and total_match_diary_read_over and total_match_article_read_over and total_match_tractate_read_over and \
                        other_key_answer_read_over and other_key_diary_read_over and other_key_article_read_over and other_key_tractate_read_over:
                    break

            # other_key_answer_read_over = False
            # other_key_diary_read_over = False
            # other_key_article_read_over = False
            # # 其次确保取完核心词命中的
            # while len(ret_list) < size:
            #     other_key_answer_read_over,answer_index = _get_answer_ret_item(ret_list, answer_results_list, answer_index, 500, 2,
            #                                                         answer_have_read_list, ans_question_read_id_set, size)
            #     other_key_diary_read_over,diary_index,have_get_diary_num = _get_diary_ret_item(ret_list, diary_results_list, diary_index, 200, 3,
            #                                                       diary_have_read_list, size)
            #     # other_key_tractate_read_over,tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list, tractate_index,
            #     #                                                         500, 1, tractate_have_read_list, size)
            #     # other_key_diary_read_over,diary_index = _get_diary_ret_item(ret_list, diary_results_list, diary_index, 200, 1,
            #     #                                                   diary_have_read_list, size)
            #     other_key_article_read_over,article_index = _get_article_ret_list(ret_list, article_results_list, article_index, 500,
            #                                                           1, article_have_read_list, size)
            #     if other_key_answer_read_over and other_key_diary_read_over and other_key_article_read_over:
            #         break

            while len(ret_list) < size:

                answer_read_over, answer_index = _get_answer_ret_item(ret_list, answer_results_list, answer_index, 0, 2,
                                                                      answer_have_read_list, ans_question_read_id_set,
                                                                      size)

                tractate_read_over, tractate_index = _get_tractate_ret_list(ret_list, tractate_results_list,
                                                                            tractate_index, 0, 2,
                                                                            tractate_have_read_list, size)

                diary_read_over, diary_index, have_get_diary_num = _get_diary_ret_item(ret_list, diary_results_list,
                                                                                       diary_index, 0, 1,
                                                                                       diary_have_read_list, size)

                article_read_over, article_index = _get_article_ret_list(ret_list, article_results_list, article_index,
                                                                         0, 1, article_have_read_list, size)

                if answer_read_over and diary_read_over and article_read_over and tractate_read_over:
                    break

        # 综搜页日记cpc插入
        cur_cpc_diary_num = 0
        for cpc_diary_id in cpc_diary_list:
            ret_list.insert(cur_cpc_diary_num, {
                "id": cpc_diary_id,
                "type": 2,
                "highlight": {},
                "is_cpc": True
            })
            cur_cpc_diary_num += 1
            if cur_cpc_diary_num >= need_cpc_diary_num:
                break

        question_id_have_read_list.extend(list(ans_question_read_id_set))
        redis_have_read_dict = {
            "answer": json.dumps(answer_have_read_list),
            "question_id": json.dumps(question_id_have_read_list),
            "article": json.dumps(article_have_read_list),
            "tractate": json.dumps(tractate_have_read_list),
            "diary": json.dumps(diary_have_read_list)
        }
        redis_client.hmset(redis_key, redis_have_read_dict)
        redis_client.expire(redis_key, 60 * 15)

        return ret_list
    except:
        logging_exception()
        logger.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
