from django.db import models


class Province(models.Model):
    class Meta:
        verbose_name = u'省份'
        verbose_name_plural = u'省份'
        db_table = 'api_province'
        app_label = 'api'

    id = models.CharField(max_length=40, primary_key=True, verbose_name=u'省份拼音名')
    name = models.CharField(max_length=20, null=False, verbose_name=u'中文名')
    display_in_filter = models.BooleanField(default=True, verbose_name=u'显示在筛选中')
    is_municipality = models.BooleanField(default=False,
                                          verbose_name=u"是否为直辖市(True:是,False:否)")


class City(models.Model):
    class Meta:
        verbose_name = u'62. 城市'
        verbose_name_plural = u'62. 城市'
        db_table = 'api_city'
        app_label = 'api'

    id = models.CharField(max_length=40, primary_key=True, verbose_name=u'拼音名')
    name = models.CharField(max_length=20, null=False, verbose_name=u'中文名')
    display_in_filter = models.BooleanField(default=True, verbose_name=u'显示在筛选中')
    is_online = models.BooleanField(default=True, verbose_name=u'是否在线')
    province = models.ForeignKey(Province, null=True, related_name='cities', verbose_name=u'省份')
    tag_id = models.IntegerField(default=None, null=True)
    level = models.PositiveIntegerField('城市级别')


class UserExtra(models.Model):
    """
    以下字段定义已复制到passport项目, 如需修改请联系passport负责人:
    user
    portrait
    """

    class Meta:
        verbose_name = '用户附加信息'
        verbose_name_plural = '用户附加信息'
        db_table = 'api_userextra'
        app_label = 'api'

    city = models.ForeignKey(City, verbose_name='城市', null=True)


class DiarySpreadFit(models.Model):
    class Meta:
        verbose_name = u'首页日记本按地域设置分布'
        app_label = 'api'

    city = models.ForeignKey(City, verbose_name=u'城市')
    commoncity = models.IntegerField(u'同城市日记本个数', default=0)
    bescity = models.IntegerField(u'临近地域日记本个数', default=0)
    is_online = models.BooleanField(u"是否下线", default=True)
    create_time = models.DateTimeField(auto_now_add=True)


class CityScale(models.Model):
    class Meta:
        verbose_name = u'城市“桶”内容按比混合'
        db_table = 'api_cityscale'
        app_label = 'api'

    city_id = models.CharField(null=False)
    native = models.PositiveIntegerField(u'本地', default=0)
    nearby = models.PositiveIntegerField(u'临近城市', default=0)
    nation = models.PositiveIntegerField(u'全国', default=0)
    megacity = models.PositiveIntegerField(u'特大城市', default=0)

class WordRel(models.Model):
    class Meta:
        verbose_name = u"词根"
        db_table = "api_wordrel"
        app_label = 'api'


    id = models.IntegerField(u"词根主键id", primary_key=True)
    keyword = models.CharField(max_length=50, null=False, verbose_name=u'中文名')

class WordRelSynonym(models.Model):
    class Meta:
        app_label = 'api'
        db_table = 'api_wordrelsynonym'

    wordrel = models.ForeignKey(WordRel, related_name='all_synonyms')
    word = models.CharField(u'同义词', max_length=50, db_index=True)

class WordRelResemble(models.Model):
    """近义词数据表
    """
    class Meta:
        app_label = 'api'
        db_table = 'api_wordrelresemble'

    wordrel = models.ForeignKey(WordRel, related_name='all_resembles')
    word = models.CharField(u'近义词', max_length=50, db_index=True)
