# coding=utf-8
"""
Django settings for doris project.

Generated by 'django-admin startproject' using Django 1.10.

For more information on this file, see
https://docs.djangoproject.com/en/1.10/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.10/ref/settings/
"""

import os
from .log_settings import *

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.10/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'w%te9@t+_hgon4dq^7udy(&l=rpzkgga1ts2(fnym8cglx)v2@'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

# Application definition

INSTALLED_APPS = [
    'dal',
    'dal_select2',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'raven.contrib.django.raven_compat',
    'json_editor',
    'word',
    'rank',
    'search',
    'recommend',
    'hera',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'dymas.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(BASE_DIR, 'templates')
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'doris.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.10/ref/settings/#databases


# Password validation
# https://docs.djangoproject.com/en/1.10/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/1.10/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.10/howto/static-files/
from django.contrib import admin

STATIC_URL = '/static/'
admin.site.site_header = '更美策略平台'
STATIC_ROOT = 'static'

WORD_FILE = '/srv/apps/doris/static/word/word.txt'
STOP_WORD_FILE = '/srv/apps/doris/static/word/stopword.txt'

ES_CONSTS = {
    'TAG_ID_DIRECTOR_RECOMMEND': 1142,  # "所长精选" tag id
    'TAG_ID_POPULAR': 1202,  # "热门讨论" tag id
    'TAG_ID_POPULAR_RECOMMEND': 1203,  # "热门推荐" tag id
    'TAG_ID_DIARY_WITH_SERVICE': 1144,  # "美购日记" tag id
}

ES_SEARCH_TIMEOUT = '10s'
COUNT_LIMIT = 200
ES_SCRIPT_LANG = 'groovy'

DIARY_SCORE_WEIGHT = {
    'HEAT_SCORE_WEIGHT': 0.6,  # 热度分权重
    'AUDIT_SCORE_WEIGHT': 0.55,  # 内容质量分权重
    'CHOUCHENG_SCORE_WEIGHT': 0.1,  # 抽成分权重
}

PENALTY_FACTOR = 1.5
RANK_EMAIL = ['doctor@gmei.com']

MAX_TAG = 3

VIDEO_TAG_ID = 4706  # 如果有小视频 就给日记本添加视频日记的tag

FEED_DIARY_NAME = "feed:{}:diaries"
FEED_QUESTION_NAME = "feed:{}:question"
FEED_ANSWER_NAME = "feed:{}:answer"
FEED_ARTICLE_NAME = "feed:{}:article"

DEVICE_PORTRAIT_NAME = "device:{}:category"

FEED_CACHE_VERSION = "v0"

DATABASE_ROUTERS = ['doris.routers.DatabaseRouter']
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'doris_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'gaia': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'zhengxing_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'mimas': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'mimas_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    "gold": {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'gold',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    }
}

# shanxi: 陕西 shannxi: 山西
NEARBY_REGION = {
    "beijing": ("hebei", "tianjin"),
    "tianjin": ("beijing", "hebei"),
    "hebei": ("beijing", "tianjin", "shandong", "henan", "shannxi", "neimenggu"),
    "shannxi": ("hebei", "shandong", "henan", "shanxi", "neimenggu"),
    "neimenggu": ("hebei", "liaoning", "jilin", "heilongjiang", "shannxi", "shanxi", "ningxia", "gansu"),
    "liaoning": ("hebei", "jilin", "neimenggu"),
    "jilin": ("liaoning", "heilongjiang", "neimenggu"),
    "heilongjiang": ("jilin", "neimenggu"),
    "shanghai": ("jiangsu", "anhui", "zhejiang"),
    "jiangsu": ("shandong", "anhui", "zhejiang", "shanghai"),
    "zhejiang": ("shanghai", "jiangsu", "anhui", "fujian"),
    "anhui": ("jiangsu", "zhejiang", "jiangxi", "hubei", "henan"),
    "fujian": ("zhejiang", "jiangxi", "guangdong"),
    "jiangxi": ("anhui", "zhejiang", "fujian", "guangdong", "hunan", "hubei"),
    "shandong": ("hebei", "henan", "jiangsu"),
    "henan": ("hebei", "shandong", "anhui", "hubei", "shanxi", "shannxi"),
    "hubei": ("henan", "anhui", "jiangxi", "hunan", "chongqing", "shanxi"),
    "hunan": ("hubei", "jiangxi", "guangdong", "guangxi", "guizhou", "chongqing"),
    "guangdong": ("guangxi", "hunan", "jiangxi", "fujian", "hainan"),
    "guangxi": ("guangdong", "hunan", "guizhou", "yunnan"),
    "hainan": ("guangdong",),
    "chongqing": ("shanxi", "hubei", "hunan", "guizhou"),
    "sichuan": ("gansu", "shanxi", "chongqing", "guizhou", "yunnan", "xizang", "qinghai"),
    "guizhou": ("chongqing", "hunan", "guangxi", "yunnan", "sichuan"),
    "yunnan": ("sichuan", "guizhou", "guangxi", "xizang"),
    "xizang": ("qinghai", "sichuan", "yunnan", "xinjiang"),
    "shanxi": ("neimenggu", "shannxi", "henan", "hubei", "chongqing", "sichuan", "gansu", "ningxia"),
    "gansu": ("ningxia", "shanxi", "sichuan", "qinghai", "xinjiang", "neimenggu"),
    "qinghai": ("gansu", "sichuan", "xizang", "xinjiang"),
    "ningxia": ("neimenggu", "shanxi", "gansu"),
    "xinjiang": ("gansu", "qinghai", "xizang"),
    "taiwan": ("fujian",),
    "xianggang": ("guangdong",),
    "aomen": ("guangdong",)
}

