# coding=utf-8
import json
import logging

from gm_rpcd.all import bind
from rank.models import Interpose


logger = logging.getLogger(__name__)

@bind('doris/interpose/get')
def get_interpose_strategy(interpose_type, city_tag_id, tag_id, sort_order, keyword=None):
    tag_ids = [0]
    city_tag_ids = [0]

    if tag_id:
        tag_ids.append(tag_id)

    if city_tag_id:
        city_tag_ids.append(city_tag_id)

    try:
        interpose = Interpose.objects.get(
            interpose_type=interpose_type,
            city_tag_id__in=city_tag_ids,
            tag_id__in=tag_ids,
            sort_order=sort_order,
            keyword=keyword,
            is_online=True,
        )
        return json.loads(interpose.object_ids)
    except Interpose.DoesNotExist:
        return None
