# coding=utf-8
import json

from django.db import models


class DoctorStat(models.Model):
    class Meta:
        unique_together=('doctor_id', 'stat_date')
    doctor_id = models.CharField(max_length=100, verbose_name="医生id", null=False)
    stat_date = models.CharField(max_length=8, verbose_name=u'日期', null=False)
    # stat_json = models.TextField(verbose_name="数据统计")
    last_30d_payment = models.FloatField(verbose_name="过去30天订单金额")
    last_30d_uv = models.FloatField(verbose_name="过去30天关联的美购详情页uv")
    last_30d_ad_money = models.FloatField(verbose_name="过去30天在广告系统内消费的金额")
    ctr = models.FloatField(verbose_name="CTR指数")
    xiadan_index = models.FloatField(verbose_name="下单指数", default=0, null=True)

    # ''' stat_json 格式
    # {
    #     'last_30d_payment':0.0, # 过去30天订单金额/
    #     'last_30d_uv':0.0, # 过去30天关联的美购详情页uv
    #     'last_30d_ad_money': 0.0, # 过去30天在广告系统内消费的金额
    #     'ctr':0.0 #  CTR指数
    # }
    # '''
    @property
    def stat_json(self):
        data = {
            'last_30d_payment': self.last_30d_payment,  # 过去30天订单金额/
            'last_30d_uv': self.last_30d_uv,  # 过去30天关联的美购详情页uv
            'last_30d_ad_money': self.last_30d_ad_money,  # 过去30天在广告系统内消费的金额
            'ctr': self.ctr,  # CTR指数,
            'xiadan_index': self.xiadan_index  # 下单指数,

        }
        return json.dumps(data)

    @property
    def redis_key(self):
        return "doctor:{}".format(
            self.doctor_id
        )