from libs.testcase import DorisTestCase
from gm_types.doris import STRATEGY_TYPE
from gm_types.doris.error import ERROR




class RankTestCase(DorisTestCase):
    fixtures = ['strategy.json']

    def test_get_doris_strategy(self):
        params = {
            "strategy_name":STRATEGY_TYPE.SERVICE_SEARCH
        }
        resp = self.call("doris/strategy/get",params)
        self.assertDictEqual(resp.result,{'a': 12, 'b': 3, 'c': 1, 'd': 5, 'e': 3})

    def test_get_wrong_strategy(self):
        params = {
            "strategy_name":'test'
        }
        resp = self.call("doris/strategy/get",params)
        self.assertEqual(resp.code, ERROR.UNSUPPORT_STRATEGY_TYPE)
