from django.core.management import BaseCommand
from libs.es import es_query
from django.conf import settings
from datetime import datetime
from libs.date import datetime_to_timestamp_millis
from libs.debug import pretty_json


class Command(BaseCommand):

    def handle(self, *args, **options):
        now = datetime.now()
        print(now)
        print(datetime_to_timestamp_millis(now))
        debug = {
            "query": {
                "bool": {
                    "must": [
                        {"range": {"can_sold_time_range.start_time_long": {"lte": now}}},
                        {"range": {"can_sold_time_range.end_time_long": {"gt": now}}},
                        {"term": {'_id': 4667198}}
                    ]
                }

            }
        }
        res = es_query('service', debug, 0, 20)
        pretty_json(res)
