from libs.testcase import DorisTestCase
from gm_types.gaia import QUESTION_ORDER_TYPE
from gm_types.gaia import SERVICE_ORDER_TYPE
from search.utils.service import recall_spu
from search.utils.board import recall_board
from libs.debug import pretty_json

class SearchTestCase(DorisTestCase):

    def test_guess_you_like_service_by_hospital(self):
        params = {
            "doctor_id":'bjgmhyy'
        }
        resp = self.call("doris/search/guess_you_like_service",params)



    def test_guess_you_like_service_by_tag(self):
        params = {
            "tag_id":1682,
        }
        resp = self.call("doris/search/guess_you_like_service",params)
        self.assertEqual(resp.code, 0)

    def test_guess_you_like_service(self):
        params = {
        }
        resp = self.call("doris/search/guess_you_like_service",params)
        self.assertEqual(resp.code, 0)


        params = {
            "doctor_id":'bjgmhyy',
            "tag_id":1682,
        }
        resp = self.call("doris/search/guess_you_like_service",params)
        self.assertEqual(resp.code, 0)


    def test_get_diaries_by_special_id(self):
        params = {
            "special_id":309,
        }
        resp = self.call("doris/search/get_diaries_by_special_id",params)
        self.assertEqual(resp.code, 0)

    def test_get_index_diaries(self):
        resp = self.call("doris/search/get_index_diaries")
        self.assertEqual(resp.code, 0)

    def test_get_doctors_by_special_id(self):
        params = {
            "special_id":491,
        }
        resp = self.call("doris/search/get_doctors_by_special_id", params)
        self.assertEqual(resp.code, 0)

    def test_get_questions_by_tag_id(self):
        params = {
            "tag_id":87,
            "sort_type": QUESTION_ORDER_TYPE.HOT
        }
        resp = self.call("doris/filter/question", params)
        self.assertEqual(resp.code, 0)

    def test_get_questions_by_tag_id(self):
        params = {
            "tag_id":87,
            "sort_type": QUESTION_ORDER_TYPE.UPDATE
        }
        resp = self.call("doris/filter/question", params)
        self.assertEqual(resp.code, 0)

    def test_query_sku_with_cashback(self):
        params = {
            "query": u"北京",
            "filters":{
                "share_get_cashback":True
            }
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code,0)

    def test_query_sku(self):
        params = {
            "query" : u'北京'
        }
        resp = self.call("doris/search/query_sku",params)
        self.assertEqual(resp.code,0)
    
    def test_query_sku_lowest_price(self):
        params = {
            "query" : u'北京',
            "sort_type": SERVICE_ORDER_TYPE.ORDER_LOWEST_PRICE
        }
        resp = self.call("doris/search/query_sku",params)
        self.assertEqual(resp.code,0)


    def test_query_sku_highest_sales(self):
        params = {
            "query": u'北京',
            "sort_type": SERVICE_ORDER_TYPE.ORDER_HIGHEST_SALES
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_query_sku_case_count(self):
        params = {
            "query": u'北京',
            "sort_type": SERVICE_ORDER_TYPE.CASE_COUNT
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_query_sku_order_evaluate(self):
        params = {
            "query": u'北京',
            "sort_type": SERVICE_ORDER_TYPE.ORDER_EVALUATE
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_query_sku_popularity(self):
        params = {
            "query": u'北京',
            "sort_type": SERVICE_ORDER_TYPE.POPULARITY
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_query_sku_distance(self):
        params = {
            "query": u'北京',
            "sort_type": SERVICE_ORDER_TYPE.DISTANCE
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_query_seckill(self):
        params = {
            "query": u'北京',
            "filters":{
                "is_seckill":True
            }
        }
        resp = self.call("doris/search/query_sku", params)
        self.assertEqual(resp.code, 0)

    def test_recall_board(self):
        filters = {
          'city_tag_id':5763
        }
        res = recall_board(query='医生',filters=filters)

    def test_recall_boadr_api(self):
        params = {"query": u'医生',"filters":{"city_tag_id":576}}
        resp = self.call("doris/search/board", params)
        print(resp.result)