from gm_rpcd.all import bind
from gm_types.doris import ARTICLE_SORT_TYPE

from search.utils.article import recall_art



@bind("doris/query/article")
def filter_article(query, offset, size, filters={}, sort_type=ARTICLE_SORT_TYPE.DEFAULT, sort_params={},use_fresh_tag=False):
    articles = recall_art(query, offset, size, filters,use_fresh_tag)
    article_list = []
    article_extra = []
    for article in articles:
        highlight = article.get("highlight", {})
        article_id = article["_source"]['id']
        article_score = article["sort"]
        article_list.append(article_id)
        article_extra.append({"id": article_id, "score": article_score, "highlight": highlight})

    return {"article_ids": article_list, "article_extra": article_extra}
