from django.db import models
import datetime
from math import log10
# Create your models here.

# @desc 用户兴趣维度表
# @rd 郑伟
# @param  device_id 用户手机设备id
# @param  tag_id    二级或三级分类
# @param  rank      用户兴趣分
# @date 20170618
class DeviceInterest(models.Model):

    class Meta:
        unique_together = (
            ('device_id', 'tag_id'),
        )

    device_id = models.CharField(max_length=100, verbose_name=u'设备ID')
    tag_id = models.IntegerField()
    rank = models.FloatField(default=0)
    updated_at = models.DateField(default=datetime.date.today)

    # @desc 计算设备兴趣分
    # @rd 郑伟
    # @param view_service_count 一周内浏览tag下美购详情页总次数  默认系数 1
    # @param favor_service_count 一周内收藏tag下所有美购总次数   默认系数 5
    # @param view_diary_count 一周内浏览tag下日记本总次数        默认系数 0.8
    # @param view_wiki_count 一周内浏览tag下百科总次数           默认系数 3
    # @date 20170624
    def cal_rank(self, view_service_count, favor_service_count, view_diary_count, view_wiki_count):
        self.rank = 0
        self.rank += log10(view_service_count+1)
        self.rank += 5*log10(favor_service_count+1)
        self.rank += 0.4*log10(view_diary_count+1)
        self.rank += 3*log10(view_wiki_count+1)



    @classmethod
    def get_realtime_interest_key(cls, device_id):
        return "interest:%s:realtime_tag" % device_id




# @desc 美购热度表
# @rd 郑伟
# @param  service_id 美购id
# @param  tag_id     二级或三级分类
# @param  rank       美购热度分
# @date 20170618
class ServiceHot(models.Model):

    class Meta:
        unique_together = (
            ('service_id', 'tag_id'),
        )


    service_id = models.IntegerField(null=True, blank=True, verbose_name=u'关联美购外键id')
    tag_id = models.IntegerField()
    rank = models.FloatField(default=0)
    updated_at = models.DateField(default=datetime.date.today)


    @classmethod
    def get_stat_key(cls, service_id):
        return "servicehot:%s:heat" % service_id


    # @desc 计算美购热度分
    # @rd 郑伟
    # @param order_validate_count 一周内订单验证量  默认系数 5
    # @param view_service_count 一周内浏览量      默认系数 0.5
    # @param ask_service_count 一周内美购咨询量        默认系数 1.5
    # @date 20170624
    def cal_rank(self, order_validate_count, view_service_count, ask_service_countunt):
        self.rank = 0
        self.rank += log10(order_validate_count+1)
        self.rank += 3*log10(view_service_count+1)
        self.rank += log10(ask_service_countunt+1)






# @desc 用户兴趣原始表
# @rd 郑伟
# @param  device_id                      用户手机设备id
# @param  tag_id                         二级或三级分类
# @param  weekly_view_service_count      一周内浏览tag下美购详情页总次数
# @param  weekly_favor_service_count     一周内收藏tag下所有美购总次数
# @param  weekly_view_diary_count        一周内浏览tag下日记本总次数
# @param  weekly_view_wiki_count         一周内浏览tag下百科总次数
# @param  updated_at                     更新日期
# @date 20170619
class DeviceInterestSource(models.Model):
    device_id = models.CharField(max_length=100, verbose_name=u'设备ID')
    tag_id = models.IntegerField()
    view_service_count = models.IntegerField()
    favor_service_count = models.IntegerField()
    view_diary_count = models.IntegerField()
    view_wiki_count = models.IntegerField()
    updated_at = models.DateField(default=datetime.date.today)


# @desc 美购热度原始表
# @rd 郑伟
# @param  service_id                     美购id
# @param  tag_id                         二级或三级分类
# @param  weekly_order_validate_count    一周内订单验证量
# @param  weekly_view_service_count      一周内浏览量
# @param  weekly_ask_service_count       一周内美购咨询量
# @param  updated_at                     更新日期
# @date 20170619
class ServiceHotSource(models.Model):
    service_id =  models.IntegerField(null=True, blank=True, verbose_name=u'关联美购外键id')
    tag_id = models.IntegerField()
    order_validate_count = models.IntegerField()
    view_service_count = models.IntegerField()
    ask_service_count = models.IntegerField()
    updated_at = models.DateField(default=datetime.date.today)





class DeviceInterestService(models.Model):
    device_id = models.CharField(max_length=100, verbose_name=u'设备ID')
    tag_id = models.IntegerField()
    rank = models.FloatField(default=0)
    updated_at = models.DateField(default=datetime.date.today)

class DeviceInterestServiceSource(models.Model):
    device_id = models.CharField(max_length=100, verbose_name=u'设备ID')
    tag_id = models.IntegerField()
    rank = models.FloatField(default=0)
    updated_at = models.DateField(default=datetime.date.today)