import functools

from django.conf import settings
from gm_types.gaia import (
    QUESTION_ORDER_TYPE,
    TOP_QUESTION_ORDER_TYPE,
    SUBSCRIPT_ARTICLE_SORT
)
from gm_rpcd.all import bind

from libs.es import es_query, get_must_query, get_es
from libs.algorithms import variousness,variousness_for_problem

from search.utils.subscript_article import recall_subscript_article


@bind('doris/filter/subscript_article')
def filter_subscript_article(query, sort_type=SUBSCRIPT_ARTICLE_SORT.ORDERING, offset=0, count=10, filters={}):
    """搜索公众号文章。

    @params: filters 过滤参数
        tag_ids: list
        category_ids: list
    """

    questions = recall_subscript_article(
        query=query,
        offset=offset,
        size=count,
        filters=filters,
        sort_type=sort_type
    )

    return {"article_ids": [item['id'] for item in questions]}
