# -*- coding: UTF-8 -*-
from hera.models import CityWhiteList
from libs.cache import redis_client


def check_city_in_whitelist(city_id):
    cache_key = 'check_city_whitelist_{city_id}'.format(city_id=city_id)
    try:
        ret = redis_client.get(cache_key)
        if ret is not None:
            ret = bool(ret)
    except:
        ret = None
    if ret is not None:
        return ret
    city_in_whitelist = CityWhiteList.objects.filter(city_id=city_id).exists()
    redis_client.set(cache_key, city_in_whitelist, 300)  # 5分钟缓存
    return city_in_whitelist
