# coding=utf-8
from gm_rpcd.all import bind

from rank.utils.cache import redis_client
import json
from libs.types import ensure_str
from recommend.models import ServiceHot
from libs.cache import redis_client  as  service_hot_redis_client

@bind('dymas/stat/doctor')
def doris_stat_doctor(doctor_id):
    redis_key = "doctor:{}".format(doctor_id)
    stat_json = redis_client.get(redis_key)
    stat_json=ensure_str(stat_json)
    if stat_json:
        return json.loads(stat_json)
    else:
        return None



# @desc 共享美购热度分数据
# @rd 郑伟
# @param  service_id 美购id
# @date 20170620
@bind("dymas/stat/service")
def doris_stat_service(service_id):
    redis_key = ServiceHot.get_stat_key(service_id)
    stat_json = service_hot_redis_client.get(redis_key)
    if stat_json:
        data = json.loads(ensure_str(stat_json))
        return data
    else:
        return {}